/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.engine.html.internal.processor;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.wiki.processor.BaseWikiPageRenameContentProcessor;
import com.liferay.wiki.processor.WikiPageRenameContentProcessor;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(property={"wiki.format.name=html"}, service={WikiPageRenameContentProcessor.class})
public class WikiPageRenameHTMLContentProcessor
extends BaseWikiPageRenameContentProcessor {
    private static final Log _log = LogFactoryUtil.getLog(WikiPageRenameHTMLContentProcessor.class);

    @Activate
    protected void activate() {
        this.regexps.put("(<img [^s]*src=\"[^g]+get_page_attachment\\?[^t]+title=)@old_title@&", "$1@new_title@&");
        this.regexps.put("(<a [^h]*href=\"[^g]+get_page_attachment\\?[^t]+title=)@old_title@&", "$1@new_title@&");
    }

    protected String runRegexps(String content, String title, String newTitle) {
        try {
            return super.runRegexps(content, URLEncoder.encode(title, "UTF-8"), URLEncoder.encode(newTitle, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)unsupportedEncodingException);
            }
            return content;
        }
    }
}

