/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.service;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageService;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;

public class WikiPageServiceUtil {
    private static volatile WikiPageService _service;

    public static WikiPage addPage(long nodeId, String title, String content, String summary, boolean minorEdit, ServiceContext serviceContext) throws PortalException {
        return WikiPageServiceUtil.getService().addPage(nodeId, title, content, summary, minorEdit, serviceContext);
    }

    @Deprecated
    public static WikiPage addPage(long nodeId, String title, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException {
        return WikiPageServiceUtil.getService().addPage(nodeId, title, content, summary, minorEdit, format, parentTitle, redirectTitle, serviceContext);
    }

    public static WikiPage addPage(String externalReferenceCode, long nodeId, String title, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException {
        return WikiPageServiceUtil.getService().addPage(externalReferenceCode, nodeId, title, content, summary, minorEdit, format, parentTitle, redirectTitle, serviceContext);
    }

    public static FileEntry addPageAttachment(long nodeId, String title, String fileName, File file, String mimeType) throws PortalException {
        return WikiPageServiceUtil.getService().addPageAttachment(nodeId, title, fileName, file, mimeType);
    }

    public static FileEntry addPageAttachment(long nodeId, String title, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        return WikiPageServiceUtil.getService().addPageAttachment(nodeId, title, fileName, inputStream, mimeType);
    }

    public static List<FileEntry> addPageAttachments(long nodeId, String title, List<ObjectValuePair<String, InputStream>> inputStreamOVPs) throws PortalException {
        return WikiPageServiceUtil.getService().addPageAttachments(nodeId, title, inputStreamOVPs);
    }

    public static FileEntry addTempFileEntry(long nodeId, String folderName, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        return WikiPageServiceUtil.getService().addTempFileEntry(nodeId, folderName, fileName, inputStream, mimeType);
    }

    public static void changeParent(long nodeId, String title, String newParentTitle, ServiceContext serviceContext) throws PortalException {
        WikiPageServiceUtil.getService().changeParent(nodeId, title, newParentTitle, serviceContext);
    }

    public static void copyPageAttachments(long templateNodeId, String templateTitle, long nodeId, String title) throws PortalException {
        WikiPageServiceUtil.getService().copyPageAttachments(templateNodeId, templateTitle, nodeId, title);
    }

    public static void deletePage(long nodeId, String title) throws PortalException {
        WikiPageServiceUtil.getService().deletePage(nodeId, title);
    }

    public static void deletePageAttachment(long nodeId, String title, String fileName) throws PortalException {
        WikiPageServiceUtil.getService().deletePageAttachment(nodeId, title, fileName);
    }

    public static void deletePageAttachments(long nodeId, String title) throws PortalException {
        WikiPageServiceUtil.getService().deletePageAttachments(nodeId, title);
    }

    public static void deleteTempFileEntry(long nodeId, String folderName, String fileName) throws PortalException {
        WikiPageServiceUtil.getService().deleteTempFileEntry(nodeId, folderName, fileName);
    }

    public static void deleteTrashPageAttachments(long nodeId, String title) throws PortalException {
        WikiPageServiceUtil.getService().deleteTrashPageAttachments(nodeId, title);
    }

    public static void discardDraft(long nodeId, String title, double version) throws PortalException {
        WikiPageServiceUtil.getService().discardDraft(nodeId, title, version);
    }

    public static WikiPage fetchLatestPageByExternalReferenceCode(long groupId, String externalReferenceCode) throws PortalException {
        return WikiPageServiceUtil.getService().fetchLatestPageByExternalReferenceCode(groupId, externalReferenceCode);
    }

    public static WikiPage fetchPage(long nodeId, String title, double version) throws PortalException {
        return WikiPageServiceUtil.getService().fetchPage(nodeId, title, version);
    }

    public static List<WikiPage> getChildren(long groupId, long nodeId, boolean head, String parentTitle) throws PortalException {
        return WikiPageServiceUtil.getService().getChildren(groupId, nodeId, head, parentTitle);
    }

    public static WikiPage getDraftPage(long nodeId, String title) throws PortalException {
        return WikiPageServiceUtil.getService().getDraftPage(nodeId, title);
    }

    public static WikiPage getLatestPageByExternalReferenceCode(long groupId, String externalReferenceCode) throws PortalException {
        return WikiPageServiceUtil.getService().getLatestPageByExternalReferenceCode(groupId, externalReferenceCode);
    }

    public static List<WikiPage> getNodePages(long nodeId, int max) throws PortalException {
        return WikiPageServiceUtil.getService().getNodePages(nodeId, max);
    }

    public static String getNodePagesRSS(long nodeId, int max, String type, double version, String displayStyle, String feedURL, String entryURL, String attachmentURLPrefix) throws PortalException {
        return WikiPageServiceUtil.getService().getNodePagesRSS(nodeId, max, type, version, displayStyle, feedURL, entryURL, attachmentURLPrefix);
    }

    public static List<WikiPage> getOrphans(WikiNode node) throws PortalException {
        return WikiPageServiceUtil.getService().getOrphans(node);
    }

    public static String getOSGiServiceIdentifier() {
        return WikiPageServiceUtil.getService().getOSGiServiceIdentifier();
    }

    public static WikiPage getPage(long pageId) throws PortalException {
        return WikiPageServiceUtil.getService().getPage(pageId);
    }

    public static WikiPage getPage(long groupId, long nodeId, String title) throws PortalException {
        return WikiPageServiceUtil.getService().getPage(groupId, nodeId, title);
    }

    public static WikiPage getPage(long nodeId, String title) throws PortalException {
        return WikiPageServiceUtil.getService().getPage(nodeId, title);
    }

    public static WikiPage getPage(long nodeId, String title, Boolean head) throws PortalException {
        return WikiPageServiceUtil.getService().getPage(nodeId, title, head);
    }

    public static WikiPage getPage(long nodeId, String title, double version) throws PortalException {
        return WikiPageServiceUtil.getService().getPage(nodeId, title, version);
    }

    public static List<WikiPage> getPages(long groupId, long nodeId, boolean head, int status, int start, int end, OrderByComparator<WikiPage> orderByComparator) throws PortalException {
        return WikiPageServiceUtil.getService().getPages(groupId, nodeId, head, status, start, end, orderByComparator);
    }

    public static List<WikiPage> getPages(long groupId, long nodeId, boolean head, long userId, boolean includeOwner, int status, int start, int end, OrderByComparator<WikiPage> orderByComparator) throws PortalException {
        return WikiPageServiceUtil.getService().getPages(groupId, nodeId, head, userId, includeOwner, status, start, end, orderByComparator);
    }

    public static List<WikiPage> getPages(long groupId, long userId, long nodeId, int status, int start, int end) throws PortalException {
        return WikiPageServiceUtil.getService().getPages(groupId, userId, nodeId, status, start, end);
    }

    public static int getPagesCount(long groupId, long nodeId, boolean head) throws PortalException {
        return WikiPageServiceUtil.getService().getPagesCount(groupId, nodeId, head);
    }

    public static int getPagesCount(long groupId, long nodeId, boolean head, long userId, boolean includeOwner, int status) throws PortalException {
        return WikiPageServiceUtil.getService().getPagesCount(groupId, nodeId, head, userId, includeOwner, status);
    }

    public static int getPagesCount(long groupId, long userId, long nodeId, int status) throws PortalException {
        return WikiPageServiceUtil.getService().getPagesCount(groupId, userId, nodeId, status);
    }

    public static String getPagesRSS(long nodeId, String title, int max, String type, double version, String displayStyle, String feedURL, String entryURL, String attachmentURLPrefix, Locale locale) throws PortalException {
        return WikiPageServiceUtil.getService().getPagesRSS(nodeId, title, max, type, version, displayStyle, feedURL, entryURL, attachmentURLPrefix, locale);
    }

    public static List<WikiPage> getRecentChanges(long groupId, long nodeId, int start, int end) throws PortalException {
        return WikiPageServiceUtil.getService().getRecentChanges(groupId, nodeId, start, end);
    }

    public static int getRecentChangesCount(long groupId, long nodeId) throws PortalException {
        return WikiPageServiceUtil.getService().getRecentChangesCount(groupId, nodeId);
    }

    public static String[] getTempFileNames(long nodeId, String folderName) throws PortalException {
        return WikiPageServiceUtil.getService().getTempFileNames(nodeId, folderName);
    }

    public static FileEntry movePageAttachmentToTrash(long nodeId, String title, String fileName) throws PortalException {
        return WikiPageServiceUtil.getService().movePageAttachmentToTrash(nodeId, title, fileName);
    }

    public static WikiPage movePageToTrash(long nodeId, String title) throws PortalException {
        return WikiPageServiceUtil.getService().movePageToTrash(nodeId, title);
    }

    public static WikiPage movePageToTrash(long nodeId, String title, double version) throws PortalException {
        return WikiPageServiceUtil.getService().movePageToTrash(nodeId, title, version);
    }

    public static void renamePage(long nodeId, String title, String newTitle, ServiceContext serviceContext) throws PortalException {
        WikiPageServiceUtil.getService().renamePage(nodeId, title, newTitle, serviceContext);
    }

    public static void restorePageAttachmentFromTrash(long nodeId, String title, String fileName) throws PortalException {
        WikiPageServiceUtil.getService().restorePageAttachmentFromTrash(nodeId, title, fileName);
    }

    public static void restorePageFromTrash(long resourcePrimKey) throws PortalException {
        WikiPageServiceUtil.getService().restorePageFromTrash(resourcePrimKey);
    }

    public static WikiPage revertPage(long nodeId, String title, double version, ServiceContext serviceContext) throws PortalException {
        return WikiPageServiceUtil.getService().revertPage(nodeId, title, version, serviceContext);
    }

    public static void subscribePage(long nodeId, String title) throws PortalException {
        WikiPageServiceUtil.getService().subscribePage(nodeId, title);
    }

    public static void unsubscribePage(long nodeId, String title) throws PortalException {
        WikiPageServiceUtil.getService().unsubscribePage(nodeId, title);
    }

    public static WikiPage updatePage(long nodeId, String title, double version, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException {
        return WikiPageServiceUtil.getService().updatePage(nodeId, title, version, content, summary, minorEdit, format, parentTitle, redirectTitle, serviceContext);
    }

    public static WikiPageService getService() {
        return _service;
    }
}

