/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.wiki.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ResourcedModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedGroupedModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.WorkflowedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the WikiPage service. Represents a row in the &quot;WikiPage&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.wiki.model.impl.WikiPageModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.wiki.model.impl.WikiPageImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see WikiPage
 * @generated
 */
@ProviderType
public interface WikiPageModel
	extends BaseModel<WikiPage>, ContainerModel, CTModel<WikiPage>, MVCCModel,
			ResourcedModel, ShardedModel, StagedGroupedModel, TrashedModel,
			WorkflowedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a wiki page model instance should use the {@link WikiPage} interface instead.
	 */

	/**
	 * Returns the primary key of this wiki page.
	 *
	 * @return the primary key of this wiki page
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this wiki page.
	 *
	 * @param primaryKey the primary key of this wiki page
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this wiki page.
	 *
	 * @return the mvcc version of this wiki page
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this wiki page.
	 *
	 * @param mvccVersion the mvcc version of this wiki page
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this wiki page.
	 *
	 * @return the ct collection ID of this wiki page
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this wiki page.
	 *
	 * @param ctCollectionId the ct collection ID of this wiki page
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the uuid of this wiki page.
	 *
	 * @return the uuid of this wiki page
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this wiki page.
	 *
	 * @param uuid the uuid of this wiki page
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the page ID of this wiki page.
	 *
	 * @return the page ID of this wiki page
	 */
	public long getPageId();

	/**
	 * Sets the page ID of this wiki page.
	 *
	 * @param pageId the page ID of this wiki page
	 */
	public void setPageId(long pageId);

	/**
	 * Returns the resource prim key of this wiki page.
	 *
	 * @return the resource prim key of this wiki page
	 */
	@Override
	public long getResourcePrimKey();

	/**
	 * Sets the resource prim key of this wiki page.
	 *
	 * @param resourcePrimKey the resource prim key of this wiki page
	 */
	@Override
	public void setResourcePrimKey(long resourcePrimKey);

	@Override
	public boolean isResourceMain();

	/**
	 * Returns the group ID of this wiki page.
	 *
	 * @return the group ID of this wiki page
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this wiki page.
	 *
	 * @param groupId the group ID of this wiki page
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this wiki page.
	 *
	 * @return the company ID of this wiki page
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this wiki page.
	 *
	 * @param companyId the company ID of this wiki page
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this wiki page.
	 *
	 * @return the user ID of this wiki page
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this wiki page.
	 *
	 * @param userId the user ID of this wiki page
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this wiki page.
	 *
	 * @return the user uuid of this wiki page
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this wiki page.
	 *
	 * @param userUuid the user uuid of this wiki page
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this wiki page.
	 *
	 * @return the user name of this wiki page
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this wiki page.
	 *
	 * @param userName the user name of this wiki page
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this wiki page.
	 *
	 * @return the create date of this wiki page
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this wiki page.
	 *
	 * @param createDate the create date of this wiki page
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this wiki page.
	 *
	 * @return the modified date of this wiki page
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this wiki page.
	 *
	 * @param modifiedDate the modified date of this wiki page
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the external reference code of this wiki page.
	 *
	 * @return the external reference code of this wiki page
	 */
	@AutoEscape
	public String getExternalReferenceCode();

	/**
	 * Sets the external reference code of this wiki page.
	 *
	 * @param externalReferenceCode the external reference code of this wiki page
	 */
	public void setExternalReferenceCode(String externalReferenceCode);

	/**
	 * Returns the node ID of this wiki page.
	 *
	 * @return the node ID of this wiki page
	 */
	public long getNodeId();

	/**
	 * Sets the node ID of this wiki page.
	 *
	 * @param nodeId the node ID of this wiki page
	 */
	public void setNodeId(long nodeId);

	/**
	 * Returns the title of this wiki page.
	 *
	 * @return the title of this wiki page
	 */
	@AutoEscape
	public String getTitle();

	/**
	 * Sets the title of this wiki page.
	 *
	 * @param title the title of this wiki page
	 */
	public void setTitle(String title);

	/**
	 * Returns the version of this wiki page.
	 *
	 * @return the version of this wiki page
	 */
	public double getVersion();

	/**
	 * Sets the version of this wiki page.
	 *
	 * @param version the version of this wiki page
	 */
	public void setVersion(double version);

	/**
	 * Returns the minor edit of this wiki page.
	 *
	 * @return the minor edit of this wiki page
	 */
	public boolean getMinorEdit();

	/**
	 * Returns <code>true</code> if this wiki page is minor edit.
	 *
	 * @return <code>true</code> if this wiki page is minor edit; <code>false</code> otherwise
	 */
	public boolean isMinorEdit();

	/**
	 * Sets whether this wiki page is minor edit.
	 *
	 * @param minorEdit the minor edit of this wiki page
	 */
	public void setMinorEdit(boolean minorEdit);

	/**
	 * Returns the content of this wiki page.
	 *
	 * @return the content of this wiki page
	 */
	@AutoEscape
	public String getContent();

	/**
	 * Sets the content of this wiki page.
	 *
	 * @param content the content of this wiki page
	 */
	public void setContent(String content);

	/**
	 * Returns the summary of this wiki page.
	 *
	 * @return the summary of this wiki page
	 */
	@AutoEscape
	public String getSummary();

	/**
	 * Sets the summary of this wiki page.
	 *
	 * @param summary the summary of this wiki page
	 */
	public void setSummary(String summary);

	/**
	 * Returns the format of this wiki page.
	 *
	 * @return the format of this wiki page
	 */
	@AutoEscape
	public String getFormat();

	/**
	 * Sets the format of this wiki page.
	 *
	 * @param format the format of this wiki page
	 */
	public void setFormat(String format);

	/**
	 * Returns the head of this wiki page.
	 *
	 * @return the head of this wiki page
	 */
	public boolean getHead();

	/**
	 * Returns <code>true</code> if this wiki page is head.
	 *
	 * @return <code>true</code> if this wiki page is head; <code>false</code> otherwise
	 */
	public boolean isHead();

	/**
	 * Sets whether this wiki page is head.
	 *
	 * @param head the head of this wiki page
	 */
	public void setHead(boolean head);

	/**
	 * Returns the parent title of this wiki page.
	 *
	 * @return the parent title of this wiki page
	 */
	@AutoEscape
	public String getParentTitle();

	/**
	 * Sets the parent title of this wiki page.
	 *
	 * @param parentTitle the parent title of this wiki page
	 */
	public void setParentTitle(String parentTitle);

	/**
	 * Returns the redirect title of this wiki page.
	 *
	 * @return the redirect title of this wiki page
	 */
	@AutoEscape
	public String getRedirectTitle();

	/**
	 * Sets the redirect title of this wiki page.
	 *
	 * @param redirectTitle the redirect title of this wiki page
	 */
	public void setRedirectTitle(String redirectTitle);

	/**
	 * Returns the last publish date of this wiki page.
	 *
	 * @return the last publish date of this wiki page
	 */
	@Override
	public Date getLastPublishDate();

	/**
	 * Sets the last publish date of this wiki page.
	 *
	 * @param lastPublishDate the last publish date of this wiki page
	 */
	@Override
	public void setLastPublishDate(Date lastPublishDate);

	/**
	 * Returns the status of this wiki page.
	 *
	 * @return the status of this wiki page
	 */
	@Override
	public int getStatus();

	/**
	 * Sets the status of this wiki page.
	 *
	 * @param status the status of this wiki page
	 */
	@Override
	public void setStatus(int status);

	/**
	 * Returns the status by user ID of this wiki page.
	 *
	 * @return the status by user ID of this wiki page
	 */
	@Override
	public long getStatusByUserId();

	/**
	 * Sets the status by user ID of this wiki page.
	 *
	 * @param statusByUserId the status by user ID of this wiki page
	 */
	@Override
	public void setStatusByUserId(long statusByUserId);

	/**
	 * Returns the status by user uuid of this wiki page.
	 *
	 * @return the status by user uuid of this wiki page
	 */
	@Override
	public String getStatusByUserUuid();

	/**
	 * Sets the status by user uuid of this wiki page.
	 *
	 * @param statusByUserUuid the status by user uuid of this wiki page
	 */
	@Override
	public void setStatusByUserUuid(String statusByUserUuid);

	/**
	 * Returns the status by user name of this wiki page.
	 *
	 * @return the status by user name of this wiki page
	 */
	@AutoEscape
	@Override
	public String getStatusByUserName();

	/**
	 * Sets the status by user name of this wiki page.
	 *
	 * @param statusByUserName the status by user name of this wiki page
	 */
	@Override
	public void setStatusByUserName(String statusByUserName);

	/**
	 * Returns the status date of this wiki page.
	 *
	 * @return the status date of this wiki page
	 */
	@Override
	public Date getStatusDate();

	/**
	 * Sets the status date of this wiki page.
	 *
	 * @param statusDate the status date of this wiki page
	 */
	@Override
	public void setStatusDate(Date statusDate);

	/**
	 * Returns the class primary key of the trash entry for this wiki page.
	 *
	 * @return the class primary key of the trash entry for this wiki page
	 */
	@Override
	public long getTrashEntryClassPK();

	/**
	 * Returns <code>true</code> if this wiki page is in the Recycle Bin.
	 *
	 * @return <code>true</code> if this wiki page is in the Recycle Bin; <code>false</code> otherwise
	 */
	@Override
	public boolean isInTrash();

	/**
	 * Returns <code>true</code> if this wiki page is approved.
	 *
	 * @return <code>true</code> if this wiki page is approved; <code>false</code> otherwise
	 */
	@Override
	public boolean isApproved();

	/**
	 * Returns <code>true</code> if this wiki page is denied.
	 *
	 * @return <code>true</code> if this wiki page is denied; <code>false</code> otherwise
	 */
	@Override
	public boolean isDenied();

	/**
	 * Returns <code>true</code> if this wiki page is a draft.
	 *
	 * @return <code>true</code> if this wiki page is a draft; <code>false</code> otherwise
	 */
	@Override
	public boolean isDraft();

	/**
	 * Returns <code>true</code> if this wiki page is expired.
	 *
	 * @return <code>true</code> if this wiki page is expired; <code>false</code> otherwise
	 */
	@Override
	public boolean isExpired();

	/**
	 * Returns <code>true</code> if this wiki page is inactive.
	 *
	 * @return <code>true</code> if this wiki page is inactive; <code>false</code> otherwise
	 */
	@Override
	public boolean isInactive();

	/**
	 * Returns <code>true</code> if this wiki page is incomplete.
	 *
	 * @return <code>true</code> if this wiki page is incomplete; <code>false</code> otherwise
	 */
	@Override
	public boolean isIncomplete();

	/**
	 * Returns <code>true</code> if this wiki page is pending.
	 *
	 * @return <code>true</code> if this wiki page is pending; <code>false</code> otherwise
	 */
	@Override
	public boolean isPending();

	/**
	 * Returns <code>true</code> if this wiki page is scheduled.
	 *
	 * @return <code>true</code> if this wiki page is scheduled; <code>false</code> otherwise
	 */
	@Override
	public boolean isScheduled();

	/**
	 * Returns the container model ID of this wiki page.
	 *
	 * @return the container model ID of this wiki page
	 */
	@Override
	public long getContainerModelId();

	/**
	 * Sets the container model ID of this wiki page.
	 *
	 * @param containerModelId the container model ID of this wiki page
	 */
	@Override
	public void setContainerModelId(long containerModelId);

	/**
	 * Returns the container name of this wiki page.
	 *
	 * @return the container name of this wiki page
	 */
	@Override
	public String getContainerModelName();

	/**
	 * Returns the parent container model ID of this wiki page.
	 *
	 * @return the parent container model ID of this wiki page
	 */
	@Override
	public long getParentContainerModelId();

	/**
	 * Sets the parent container model ID of this wiki page.
	 *
	 * @param parentContainerModelId the parent container model ID of this wiki page
	 */
	@Override
	public void setParentContainerModelId(long parentContainerModelId);

	@Override
	public WikiPage cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}