/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.engine;

import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.servlet.PipingServletResponse;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.LanguageResources;
import com.liferay.wiki.engine.WikiEngine;
import com.liferay.wiki.exception.PageContentException;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletURL;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

public abstract class BaseWikiEngine
implements WikiEngine {
    private static final String _BASE_WIKI_ENGINE = BaseWikiEngine.class.getName() + "#BASE_WIKI_ENGINE";
    private static final String _WIKI_NODE = BaseWikiEngine.class.getName() + "#WIKI_NODE";
    private static final String _WIKI_PAGE = BaseWikiEngine.class.getName() + "#WIKI_PAGE";

    public static BaseWikiEngine getBaseWikiEngine(ServletRequest servletRequest) {
        return (BaseWikiEngine)servletRequest.getAttribute(_BASE_WIKI_ENGINE);
    }

    public static WikiNode getWikiNode(ServletRequest servletRequest) {
        return (WikiNode)servletRequest.getAttribute(_WIKI_NODE);
    }

    public static WikiPage getWikiPage(ServletRequest servletRequest) {
        return (WikiPage)servletRequest.getAttribute(_WIKI_PAGE);
    }

    @Override
    public String convert(WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) {
        return page.getContent();
    }

    public abstract String getEditorName();

    @Override
    public String getFormatLabel(Locale locale) {
        String format;
        ResourceBundleLoader resourceBundleLoader = this.getResourceBundleLoader();
        ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
        String formatLabel = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)(format = this.getFormat()));
        if (formatLabel != null) {
            return formatLabel;
        }
        return format;
    }

    public String getHelpPageHTML(PageContext pageContext) throws IOException, ServletException {
        if (!this.isHelpPageDefined()) {
            return "";
        }
        HttpServletResponse httpServletResponse = (HttpServletResponse)pageContext.getResponse();
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        PipingServletResponse pipingServletResponse = new PipingServletResponse(httpServletResponse, (Writer)unsyncStringWriter);
        ServletContext servletContext = this.getHelpPageServletContext();
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(this.getHelpPageJSP());
        requestDispatcher.include(pageContext.getRequest(), (ServletResponse)pipingServletResponse);
        StringBundler sb = unsyncStringWriter.getStringBundler();
        return sb.toString();
    }

    public String getHelpPageTitle(HttpServletRequest httpServletRequest) {
        return LanguageUtil.format((HttpServletRequest)httpServletRequest, (String)"x-syntax-help", (Object)this.getFormatLabel(httpServletRequest.getLocale()), (boolean)false);
    }

    public abstract String getHelpURL();

    @Override
    public Map<String, Boolean> getOutgoingLinks(WikiPage page) throws PageContentException {
        return Collections.emptyMap();
    }

    @Override
    public String getToolbarSet() {
        return "creole";
    }

    public boolean isHelpPageDefined() {
        return this.getHelpPageServletContext() != null && !Validator.isNull((String)this.getHelpPageJSP());
    }

    @Override
    public void renderEditPage(ServletRequest servletRequest, ServletResponse servletResponse, WikiNode node, WikiPage page) throws IOException, ServletException {
        ServletContext servletContext = this.getEditPageServletContext();
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(this.getEditPageJSP());
        servletRequest.setAttribute(_BASE_WIKI_ENGINE, (Object)this);
        servletRequest.setAttribute(_WIKI_NODE, (Object)node);
        servletRequest.setAttribute(_WIKI_PAGE, (Object)page);
        requestDispatcher.include(servletRequest, servletResponse);
    }

    @Override
    public boolean validate(long nodeId, String newContent) {
        return true;
    }

    protected String getEditPageJSP() {
        return "/edit_page.jsp";
    }

    protected abstract ServletContext getEditPageServletContext();

    protected String getHelpPageJSP() {
        return "/help_page.jsp";
    }

    protected abstract ServletContext getHelpPageServletContext();

    protected ResourceBundleLoader getResourceBundleLoader() {
        return LanguageResources.PORTAL_RESOURCE_BUNDLE_LOADER;
    }
}

