/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.web.url.apio.internal.architect.router;

import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.router.ReusableNestedCollectionRouter;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.portal.apio.identifier.ClassNameClassPK;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.service.WebsiteService;
import com.liferay.web.url.apio.architect.identifier.WebUrlIdentifier;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ReusableNestedCollectionRouter.class})
public class WebUrlReusableNestedCollectionRouter
implements ReusableNestedCollectionRouter<Website, Long, WebUrlIdentifier, ClassNameClassPK> {
    @Reference
    private OrganizationService _organizationService;
    @Reference
    private UserService _userService;
    @Reference
    private WebsiteService _websiteService;

    public NestedCollectionRoutes<Website, Long, ClassNameClassPK> collectionRoutes(NestedCollectionRoutes.Builder<Website, Long, ClassNameClassPK> builder) {
        return builder.addGetter(this::_getPageItems).build();
    }

    private PageItems<Website> _getPageItems(Pagination pagination, ClassNameClassPK classNameClassPK) throws PortalException {
        List<Website> websites = this._getWebsites(classNameClassPK);
        int endPosition = Math.min(websites.size(), pagination.getEndPosition());
        return new PageItems(websites.subList(pagination.getStartPosition(), endPosition), websites.size());
    }

    private List<Website> _getWebsites(ClassNameClassPK classNameClassPK) throws PortalException {
        String className = classNameClassPK.getClassName();
        if (className.equals(Organization.class.getName())) {
            Organization organization = this._organizationService.getOrganization(classNameClassPK.getClassPK());
            return this._websiteService.getWebsites(organization.getModelClassName(), organization.getOrganizationId());
        }
        User user = this._userService.getUserById(classNameClassPK.getClassPK());
        return this._websiteService.getWebsites(Contact.class.getName(), user.getContactId());
    }
}

