/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.web.page.element.apio.internal.architect.resource;

import com.liferay.aggregate.rating.apio.architect.identifier.AggregateRatingIdentifier;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.asset.kernel.model.AssetTagModel;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.category.apio.architect.identifier.CategoryIdentifier;
import com.liferay.comment.apio.architect.identifier.CommentIdentifier;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.model.JournalArticleModel;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.journal.util.JournalContent;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.portal.apio.idempotent.Idempotent;
import com.liferay.portal.apio.identifier.ClassNameClassPK;
import com.liferay.portal.apio.permission.HasPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.site.apio.architect.identifier.WebSiteIdentifier;
import com.liferay.web.page.element.apio.architect.identifier.WebPageElementIdentifier;
import com.liferay.web.page.element.apio.internal.architect.form.WebPageElementCreatorForm;
import com.liferay.web.page.element.apio.internal.architect.form.WebPageElementUpdaterForm;
import com.liferay.web.page.element.apio.internal.model.JournalArticleWrapper;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class WebPageElementNestedCollectionResource
implements NestedCollectionResource<JournalArticleWrapper, Long, WebPageElementIdentifier, Long, WebSiteIdentifier> {
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalArticle)")
    private HasPermission<Long> _hasPermission;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private JournalContent _journalContent;

    public NestedCollectionRoutes<JournalArticleWrapper, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<JournalArticleWrapper, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems, ThemeDisplay.class).addCreator(this::_addJournalArticle, ThemeDisplay.class, this._hasPermission.forAddingIn(WebSiteIdentifier.class), WebPageElementCreatorForm::buildForm).build();
    }

    public String getName() {
        return "web-page-element";
    }

    public ItemRoutes<JournalArticleWrapper, Long> itemRoutes(ItemRoutes.Builder<JournalArticleWrapper, Long> builder) {
        return builder.addGetter(this::_getJournalArticleWrapper, ThemeDisplay.class).addRemover(Idempotent.idempotent(this::_deleteJournalArticle), (arg_0, arg_1) -> this._hasPermission.forDeleting(arg_0, arg_1)).addUpdater(this::_updateJournalArticle, ThemeDisplay.class, (arg_0, arg_1) -> this._hasPermission.forUpdating(arg_0, arg_1), WebPageElementUpdaterForm::buildForm).build();
    }

    public Representor<JournalArticleWrapper> representor(Representor.Builder<JournalArticleWrapper, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("WebPageElement", new String[0]).identifier(JournalArticleModel::getId).addBidirectionalModel("webSite", "webPageElements", WebSiteIdentifier.class, JournalArticleModel::getGroupId).addDate("dateCreated", JournalArticleModel::getCreateDate)).addDate("dateModified", JournalArticleModel::getModifiedDate)).addDate("datePublished", JournalArticleModel::getDisplayDate)).addDate("lastReviewed", JournalArticleModel::getReviewDate)).addLinkedModel("aggregateRating", AggregateRatingIdentifier.class, this::_createClassNameClassPK)).addLinkedModel("author", PersonIdentifier.class, JournalArticleModel::getUserId)).addLinkedModel("creator", PersonIdentifier.class, JournalArticleModel::getUserId)).addLocalizedStringByLocale("renderedContent", this::_getJournalArticleHtml)).addRelatedCollection("categories", CategoryIdentifier.class).addRelatedCollection("comments", CommentIdentifier.class).addString("description", com.liferay.journal.model.JournalArticleWrapper::getDescription)).addString("text", JournalArticleModel::getContent)).addString("title", JournalArticle::getTitle)).addStringList("keywords", this::_getJournalArticleAssetTags)).build();
    }

    private JournalArticleWrapper _addJournalArticle(long webSiteId, WebPageElementCreatorForm webPageElementCreatorForm, ThemeDisplay themeDisplay) throws PortalException {
        Locale locale = themeDisplay.getLocale();
        ServiceContext serviceContext = webPageElementCreatorForm.getServiceContext(webSiteId);
        JournalArticle journalArticle = this._journalArticleService.addArticle(webSiteId, 0L, 0L, 0L, null, true, webPageElementCreatorForm.getTitleMap(locale), webPageElementCreatorForm.getDescriptionMap(locale), webPageElementCreatorForm.getText(), webPageElementCreatorForm.getStructure(), webPageElementCreatorForm.getTemplate(), null, webPageElementCreatorForm.getDisplayDateMonth(), webPageElementCreatorForm.getDisplayDateDay(), webPageElementCreatorForm.getDisplayDateYear(), webPageElementCreatorForm.getDisplayDateHour(), webPageElementCreatorForm.getDisplayDateMinute(), 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, null, serviceContext);
        return new JournalArticleWrapper(journalArticle, themeDisplay);
    }

    private ClassNameClassPK _createClassNameClassPK(JournalArticle journalArticle) {
        return ClassNameClassPK.create((String)JournalArticle.class.getName(), (long)journalArticle.getResourcePrimKey());
    }

    private void _deleteJournalArticle(long journalArticleId) throws PortalException {
        JournalArticle journalArticle = this._journalArticleService.getArticle(journalArticleId);
        this._journalArticleService.deleteArticle(journalArticle.getGroupId(), journalArticle.getArticleId(), journalArticle.getArticleResourceUuid(), new ServiceContext());
    }

    private List<String> _getJournalArticleAssetTags(JournalArticle journalArticle) {
        List assetTags = this._assetTagLocalService.getTags(JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
        return ListUtil.toList((List)assetTags, AssetTagModel::getName);
    }

    private String _getJournalArticleHtml(JournalArticleWrapper journalArticleWrapper, Locale locale) {
        JournalArticleDisplay journalArticleDisplay = this._journalContent.getDisplay(journalArticleWrapper.getGroupId(), journalArticleWrapper.getArticleId(), null, locale.getLanguage(), journalArticleWrapper.getThemeDisplay());
        String content = journalArticleDisplay.getContent();
        if (content == null) {
            return null;
        }
        return content.replaceAll("[\\t\\n]", "");
    }

    private JournalArticleWrapper _getJournalArticleWrapper(long journalArticleId, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticle journalArticle = this._journalArticleService.getArticle(journalArticleId);
        return new JournalArticleWrapper(journalArticle, themeDisplay);
    }

    private PageItems<JournalArticleWrapper> _getPageItems(Pagination pagination, long webSiteId, ThemeDisplay themeDisplay) {
        List journalArticleWrappers = Stream.of(this._journalArticleService.getArticles(webSiteId, 0L, pagination.getStartPosition(), pagination.getEndPosition(), null)).flatMap(Collection::stream).map(journalArticle -> new JournalArticleWrapper((JournalArticle)journalArticle, themeDisplay)).collect(Collectors.toList());
        int count = this._journalArticleService.getArticlesCount(webSiteId, 0L);
        return new PageItems(journalArticleWrappers, count);
    }

    private JournalArticleWrapper _updateJournalArticle(long journalArticleId, WebPageElementUpdaterForm webPageElementUpdaterForm, ThemeDisplay themeDisplay) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(webPageElementUpdaterForm.getGroup());
        JournalArticle journalArticle = this._journalArticleService.updateArticle(webPageElementUpdaterForm.getUser(), webPageElementUpdaterForm.getGroup(), 0L, String.valueOf(journalArticleId), (double)webPageElementUpdaterForm.getVersion(), webPageElementUpdaterForm.getTitleMap(), webPageElementUpdaterForm.getDescriptionMap(), webPageElementUpdaterForm.getText(), null, serviceContext);
        return new JournalArticleWrapper(journalArticle, themeDisplay);
    }
}

