/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.web.page.element.apio.internal.architect.form;

import com.liferay.apio.architect.form.Form;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class WebPageElementCreatorForm {
    private String _description;
    private Integer _displayDateDay;
    private Integer _displayDateHour;
    private Integer _displayDateMinute;
    private Integer _displayDateMonth;
    private Integer _displayDateYear;
    private List<String> _keywords;
    private String _structure;
    private String _template;
    private String _text;
    private String _title;

    public static Form<WebPageElementCreatorForm> buildForm(Form.Builder<WebPageElementCreatorForm> formBuilder) {
        return formBuilder.title(__ -> "The web page element creator form").description(__ -> "This form can be used to create a web page element").constructor(WebPageElementCreatorForm::new).addOptionalStringList("keywords", WebPageElementCreatorForm::_setKeywords).addRequiredDate("displayDate", WebPageElementCreatorForm::_setDisplayDate).addRequiredString("description", WebPageElementCreatorForm::_setDescription).addRequiredString("structure", WebPageElementCreatorForm::_setStructure).addRequiredString("template", WebPageElementCreatorForm::_setTemplate).addRequiredString("text", WebPageElementCreatorForm::_setText).addRequiredString("title", WebPageElementCreatorForm::_setTitle).build();
    }

    public Map<Locale, String> getDescriptionMap(Locale locale) {
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(locale, this._description);
        return descriptionMap;
    }

    public int getDisplayDateDay() {
        return this._displayDateDay;
    }

    public int getDisplayDateHour() {
        return this._displayDateHour;
    }

    public int getDisplayDateMinute() {
        return this._displayDateMinute;
    }

    public int getDisplayDateMonth() {
        return this._displayDateMonth;
    }

    public int getDisplayDateYear() {
        return this._displayDateYear;
    }

    public ServiceContext getServiceContext(long groupId) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(groupId);
        if (ListUtil.isNotEmpty(this._keywords)) {
            serviceContext.setAssetTagNames(ArrayUtil.toStringArray(this._keywords));
        }
        return serviceContext;
    }

    public String getStructure() {
        return this._structure;
    }

    public String getTemplate() {
        return this._template;
    }

    public String getText() {
        return this._text;
    }

    public Map<Locale, String> getTitleMap(Locale locale) {
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        titleMap.put(locale, this._title);
        return titleMap;
    }

    private void _setDescription(String description) {
        this._description = description;
    }

    private void _setDisplayDate(Date displayDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(displayDate);
        this._displayDateMonth = calendar.get(2);
        this._displayDateDay = calendar.get(5);
        this._displayDateYear = calendar.get(1);
        this._displayDateHour = calendar.get(10);
        this._displayDateMinute = calendar.get(12);
    }

    private void _setKeywords(List<String> keywords) {
        this._keywords = keywords;
    }

    private void _setStructure(String structure) {
        this._structure = structure;
    }

    private void _setTemplate(String template) {
        this._template = template;
    }

    private void _setText(String text) {
        this._text = text;
    }

    private void _setTitle(String title) {
        this._title = title;
    }
}

