/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import javax.portlet.RenderResponse;
import javax.portlet.RenderURL;

public class UsersAdminPortletURLUtil {
    public static String createOrganizationViewTreeURL(long organizationId, RenderResponse renderResponse) {
        RenderURL renderURL = (RenderURL)renderResponse.createRenderURL();
        renderURL.setParameter("mvcRenderCommandName", "/users_admin/view");
        renderURL.setParameter("toolbarItem", "view-all-organizations");
        if (organizationId == 0L) {
            renderURL.setParameter("usersListView", "flat-organizations");
        } else {
            renderURL.setParameter("organizationId", String.valueOf(organizationId));
            renderURL.setParameter("usersListView", "tree");
        }
        return String.valueOf(renderURL);
    }

    public static String createParentOrganizationViewTreeURL(long organizationId, RenderResponse renderResponse) throws PortalException {
        return UsersAdminPortletURLUtil.createParentOrganizationViewTreeURL(OrganizationLocalServiceUtil.fetchOrganization((long)organizationId), renderResponse);
    }

    public static String createParentOrganizationViewTreeURL(Organization organization, RenderResponse renderResponse) throws PortalException {
        if (organization != null && !organization.isRoot()) {
            long parentOrganizationId = organization.getParentOrganizationId();
            if (OrganizationPermissionUtil.contains((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (long)parentOrganizationId, (String)"VIEW")) {
                return UsersAdminPortletURLUtil.createOrganizationViewTreeURL(parentOrganizationId, renderResponse);
            }
        }
        return UsersAdminPortletURLUtil.createOrganizationViewTreeURL(0L, renderResponse);
    }
}

