/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.NoSuchOrganizationException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_users_admin_web_portlet_MyOrganizationsPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_UsersAdminPortlet", "mvc.command.name=/users_admin/update_organization_reminder_queries"}, service={MVCActionCommand.class})
public class UpdateOrganizationReminderQueriesMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private OrganizationService _organizationService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.updateReminderQueries((PortletRequest)actionRequest);
        }
        catch (Exception e) {
            String mvcPath = "/edit_organization.jsp";
            if (e instanceof NoSuchOrganizationException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                mvcPath = "/error.jsp";
            }
            actionResponse.setRenderParameter("mvcPath", mvcPath);
        }
    }

    protected void updateReminderQueries(PortletRequest portletRequest) throws Exception {
        long organizationId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"organizationId");
        Organization organization = this._organizationService.getOrganization(organizationId);
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        OrganizationPermissionUtil.check((PermissionChecker)themeDisplay.getPermissionChecker(), (Organization)organization, (String)"UPDATE");
        String reminderQueries = portletRequest.getParameter("reminderQueries");
        PortletPreferences portletPreferences = organization.getPreferences();
        LocalizationUtil.setLocalizedPreferencesValues((PortletRequest)portletRequest, (PortletPreferences)portletPreferences, (String)"reminderQueries");
        portletPreferences.setValue("reminderQueries", reminderQueries);
        portletPreferences.store();
    }
}

