/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.NoSuchOrganizationException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.EmailAddressService;
import com.liferay.portal.kernel.service.OrgLaborService;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.PhoneService;
import com.liferay.portal.kernel.service.WebsiteService;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.sites.kernel.util.Sites;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_users_admin_web_portlet_MyOrganizationsPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_UsersAdminPortlet", "mvc.command.name=/users_admin/update_organization_organization_site"}, service={MVCActionCommand.class})
public class UpdateOrganizationOrganizationSiteMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private EmailAddressService _emailAddressService;
    @Reference
    private OrganizationService _organizationService;
    @Reference
    private OrgLaborService _orgLaborService;
    @Reference
    private PhoneService _phoneService;
    @Reference
    private Sites _sites;
    @Reference
    private WebsiteService _websiteService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.updateOrganizationSite(actionRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchOrganizationException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            throw e;
        }
    }

    protected void updateOrganizationSite(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long organizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"organizationId");
        Organization organization = this._organizationService.getOrganization(organizationId);
        boolean site = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"site");
        List emailAddresses = this._emailAddressService.getEmailAddresses(Organization.class.getName(), organizationId);
        List orgLabors = this._orgLaborService.getOrgLabors(organizationId);
        List phones = this._phoneService.getPhones(Organization.class.getName(), organizationId);
        List websites = this._websiteService.getWebsites(Organization.class.getName(), organizationId);
        organization = this._organizationService.updateOrganization(organizationId, organization.getParentOrganizationId(), organization.getName(), organization.getType(), organization.getRegionId(), organization.getCountryId(), organization.getStatusId(), organization.getComments(), true, null, site, organization.getAddresses(), emailAddresses, orgLabors, phones, websites, null);
        Group organizationGroup = organization.getGroup();
        if (GroupPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Group)organizationGroup, (String)"UPDATE")) {
            long publicLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"publicLayoutSetPrototypeId");
            long privateLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"privateLayoutSetPrototypeId");
            boolean publicLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"publicLayoutSetPrototypeLinkEnabled", (publicLayoutSetPrototypeId > 0L ? 1 : 0) != 0);
            boolean privateLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayoutSetPrototypeLinkEnabled", (privateLayoutSetPrototypeId > 0L ? 1 : 0) != 0);
            this._sites.updateLayoutSetPrototypesLinks(organizationGroup, publicLayoutSetPrototypeId, privateLayoutSetPrototypeId, publicLayoutSetPrototypeLinkEnabled, privateLayoutSetPrototypeLinkEnabled);
        }
    }
}

