/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.AddressCityException;
import com.liferay.portal.kernel.exception.AddressStreetException;
import com.liferay.portal.kernel.exception.AddressZipException;
import com.liferay.portal.kernel.exception.NoSuchCountryException;
import com.liferay.portal.kernel.exception.NoSuchListTypeException;
import com.liferay.portal.kernel.exception.NoSuchOrganizationException;
import com.liferay.portal.kernel.exception.NoSuchRegionException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.users.admin.kernel.util.UsersAdmin;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_users_admin_web_portlet_MyOrganizationsPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_UsersAdminPortlet", "mvc.command.name=/users_admin/update_organization_addresses"}, service={MVCActionCommand.class})
public class UpdateOrganizationAddressesMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private OrganizationService _organizationService;
    @Reference
    private Portal _portal;
    @Reference
    private UsersAdmin _usersAdmin;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.updateAddresses(actionRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchOrganizationException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            if (e instanceof AddressCityException || e instanceof AddressStreetException || e instanceof AddressZipException || e instanceof NoSuchCountryException || e instanceof NoSuchListTypeException || e instanceof NoSuchRegionException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                actionResponse.setRenderParameter("mvcPath", "/edit_organization.jsp");
            }
            throw e;
        }
    }

    protected void updateAddresses(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long organizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"organizationId");
        Organization organization = this._organizationService.getOrganization(organizationId);
        OrganizationPermissionUtil.check((PermissionChecker)themeDisplay.getPermissionChecker(), (Organization)organization, (String)"UPDATE");
        List addresses = UsersAdminUtil.getAddresses((ActionRequest)actionRequest);
        if (addresses != null) {
            this._usersAdmin.updateAddresses(Organization.class.getName(), organizationId, addresses);
        }
    }
}

