/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.AddressCityException;
import com.liferay.portal.kernel.exception.AddressStreetException;
import com.liferay.portal.kernel.exception.AddressZipException;
import com.liferay.portal.kernel.exception.DuplicateOpenIdException;
import com.liferay.portal.kernel.exception.EmailAddressException;
import com.liferay.portal.kernel.exception.NoSuchCountryException;
import com.liferay.portal.kernel.exception.NoSuchListTypeException;
import com.liferay.portal.kernel.exception.NoSuchOrgLaborException;
import com.liferay.portal.kernel.exception.NoSuchOrganizationException;
import com.liferay.portal.kernel.exception.NoSuchRegionException;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PhoneNumberException;
import com.liferay.portal.kernel.exception.PhoneNumberExtensionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.exception.UserSmsException;
import com.liferay.portal.kernel.exception.WebsiteURLException;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.AddressLocalService;
import com.liferay.portal.kernel.service.AddressService;
import com.liferay.portal.kernel.service.EmailAddressLocalService;
import com.liferay.portal.kernel.service.EmailAddressService;
import com.liferay.portal.kernel.service.OrgLaborLocalService;
import com.liferay.portal.kernel.service.OrgLaborService;
import com.liferay.portal.kernel.service.PhoneLocalService;
import com.liferay.portal.kernel.service.PhoneService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WebsiteLocalService;
import com.liferay.portal.kernel.service.WebsiteService;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.users.admin.kernel.util.UsersAdmin;
import com.liferay.users.admin.web.internal.manager.AddressContactInfoManager;
import com.liferay.users.admin.web.internal.manager.ContactInfoManager;
import com.liferay.users.admin.web.internal.manager.EmailAddressContactInfoManager;
import com.liferay.users.admin.web.internal.manager.OrgLaborContactInfoManager;
import com.liferay.users.admin.web.internal.manager.PhoneContactInfoManager;
import com.liferay.users.admin.web.internal.manager.WebsiteContactInfoManager;
import java.util.Objects;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_my_account_web_portlet_MyAccountPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_MyOrganizationsPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_UsersAdminPortlet", "mvc.command.name=/users_admin/update_contact_information"}, service={MVCActionCommand.class})
public class UpdateContactInformationMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private AddressLocalService _addressLocalService;
    @Reference
    private AddressService _addressService;
    @Reference
    private EmailAddressLocalService _emailAddressLocalService;
    @Reference
    private EmailAddressService _emailAddressService;
    @Reference
    private OrgLaborLocalService _orgLaborLocalService;
    @Reference
    private OrgLaborService _orgLaborService;
    @Reference
    private PhoneLocalService _phoneLocalService;
    @Reference
    private PhoneService _phoneService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private UsersAdmin _usersAdmin;
    @Reference
    private WebsiteLocalService _websiteLocalService;
    @Reference
    private WebsiteService _websiteService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String className = ParamUtil.getString((PortletRequest)actionRequest, (String)"className");
        long classPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classPK");
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._checkPermission(themeDisplay.getPermissionChecker(), className, classPK);
            this._updateContactInformation(actionRequest, className, classPK);
            String redirect = this._portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e) {
            if (e instanceof NoSuchOrganizationException || e instanceof NoSuchUserException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            if (e instanceof AddressCityException || e instanceof AddressStreetException || e instanceof AddressZipException || e instanceof DuplicateOpenIdException || e instanceof EmailAddressException || e instanceof NoSuchCountryException || e instanceof NoSuchListTypeException || e instanceof NoSuchOrgLaborException || e instanceof NoSuchRegionException || e instanceof PhoneNumberException || e instanceof PhoneNumberExtensionException || e instanceof UserEmailAddressException || e instanceof UserSmsException || e instanceof WebsiteURLException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                String errorMVCPath = ParamUtil.getString((PortletRequest)actionRequest, (String)"errorMVCPath");
                if (Validator.isNotNull((String)errorMVCPath)) {
                    actionResponse.setRenderParameter("mvcPath", errorMVCPath);
                } else {
                    actionResponse.setRenderParameter("mvcPath", this._getEditMVCPath(className));
                }
            }
            throw e;
        }
    }

    private void _checkPermission(PermissionChecker permissionChecker, String className, long classPK) throws PortalException {
        if (Objects.equals(className, Organization.class.getName())) {
            OrganizationPermissionUtil.check((PermissionChecker)permissionChecker, (long)classPK, (String)"UPDATE");
        } else {
            User user = this._userLocalService.getUserByContactId(classPK);
            UserPermissionUtil.check((PermissionChecker)permissionChecker, (long)user.getUserId(), (String)"UPDATE");
        }
    }

    private ContactInfoManager _getContactInformationHelper(String className, long classPK, String listType) {
        if (listType.equals(".address")) {
            return new AddressContactInfoManager(className, classPK, this._addressLocalService, this._addressService);
        }
        if (listType.equals(".emailAddress")) {
            return new EmailAddressContactInfoManager(className, classPK, this._emailAddressLocalService, this._emailAddressService, this._usersAdmin);
        }
        if (listType.equals(".phone")) {
            return new PhoneContactInfoManager(className, classPK, this._phoneLocalService, this._phoneService, this._usersAdmin);
        }
        if (listType.equals(ListTypeConstants.ORGANIZATION_SERVICE)) {
            return new OrgLaborContactInfoManager(classPK, this._orgLaborLocalService, this._orgLaborService);
        }
        if (listType.equals(".website")) {
            return new WebsiteContactInfoManager(className, classPK, this._websiteLocalService, this._websiteService, this._usersAdmin);
        }
        return null;
    }

    private String _getEditMVCPath(String className) {
        if (Objects.equals(className, Organization.class.getName())) {
            return "/edit_organization.jsp";
        }
        return "/edit_user.jsp";
    }

    private void _updateContactInformation(ActionRequest actionRequest, String className, long classPK) throws Exception {
        String listType = ParamUtil.getString((PortletRequest)actionRequest, (String)"listType");
        ContactInfoManager contactInformationHelper = this._getContactInformationHelper(className, classPK, listType);
        if (contactInformationHelper == null) {
            throw new NoSuchListTypeException();
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        long primaryKey = ParamUtil.getLong((PortletRequest)actionRequest, (String)"primaryKey");
        if (cmd.equals("delete")) {
            contactInformationHelper.delete(primaryKey);
        } else if (cmd.equals("edit")) {
            contactInformationHelper.edit(actionRequest);
        } else if (cmd.equals("makePrimary")) {
            contactInformationHelper.makePrimary(primaryKey);
        }
    }
}

