/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.NoSuchOrganizationException;
import com.liferay.portal.kernel.exception.RequiredOrganizationException;
import com.liferay.portal.kernel.exception.RequiredUserException;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_users_admin_web_portlet_UsersAdminPortlet", "mvc.command.name=/users_admin/delete_organizations_and_users"}, service={MVCActionCommand.class})
public class DeleteOrganizationsAndUsersMVCActionCommand
extends BaseMVCActionCommand {
    private OrganizationService _organizationService;
    @Reference
    private Portal _portal;
    private UserService _userService;

    protected void deleteOrganizations(ActionRequest actionRequest) throws Exception {
        long[] deleteOrganizationIds;
        for (long deleteOrganizationId : deleteOrganizationIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteOrganizationIds"), (long)0L)) {
            this._organizationService.deleteOrganization(deleteOrganizationId);
        }
    }

    protected void deleteUsers(ActionRequest actionRequest) throws Exception {
        long[] deleteUserIds;
        for (long deleteUserId : deleteUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteUserIds"), (long)0L)) {
            this._userService.deleteUser(deleteUserId);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.deleteOrganizations(actionRequest);
            this.deleteUsers(actionRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchOrganizationException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            if (e instanceof RequiredOrganizationException || e instanceof RequiredUserException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                String redirect = this._portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"onErrorRedirect"));
                if (Validator.isNotNull((String)redirect)) {
                    this.sendRedirect(actionRequest, actionResponse, redirect);
                    return;
                }
            }
            throw e;
        }
    }

    @Reference(unbind="-")
    protected void setOrganizationService(OrganizationService organizationService) {
        this._organizationService = organizationService;
    }

    @Reference(unbind="-")
    protected void setUserService(UserService userService) {
        this._userService = userService;
    }
}

