/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.manager;

import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WebsiteLocalService;
import com.liferay.portal.kernel.service.WebsiteService;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.users.admin.kernel.util.UsersAdmin;
import com.liferay.users.admin.web.internal.manager.BaseContactInfoManager;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;

public class WebsiteContactInfoManager
extends BaseContactInfoManager<Website> {
    private final String _className;
    private final long _classPK;
    private final UsersAdmin _usersAdmin;
    private final WebsiteLocalService _websiteLocalService;
    private final WebsiteService _websiteService;

    public WebsiteContactInfoManager(String className, long classPK, WebsiteLocalService websiteLocalService, WebsiteService websiteService, UsersAdmin usersAdmin) {
        this._className = className;
        this._classPK = classPK;
        this._websiteLocalService = websiteLocalService;
        this._websiteService = websiteService;
        this._usersAdmin = usersAdmin;
    }

    @Override
    protected Website construct(ActionRequest actionRequest) throws Exception {
        long websiteId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"primaryKey");
        String url = ParamUtil.getString((PortletRequest)actionRequest, (String)"websiteUrl");
        long typeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"websiteTypeId");
        boolean primary = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"websitePrimary");
        Website website = this._websiteLocalService.createWebsite(websiteId);
        website.setUrl(url);
        website.setTypeId(typeId);
        website.setPrimary(primary);
        return website;
    }

    @Override
    protected Website doAdd(Website website) throws Exception {
        return this._websiteService.addWebsite(this._className, this._classPK, website.getUrl(), website.getTypeId(), website.isPrimary(), new ServiceContext());
    }

    @Override
    protected void doDelete(long websiteId) throws Exception {
        this._websiteService.deleteWebsite(websiteId);
    }

    @Override
    protected void doUpdate(Website website) throws Exception {
        this._websiteService.updateWebsite(website.getWebsiteId(), website.getUrl(), website.getTypeId(), website.isPrimary());
    }

    @Override
    protected Website get(long websiteId) throws Exception {
        return this._websiteService.getWebsite(websiteId);
    }

    @Override
    protected List<Website> getAll() throws Exception {
        return this._websiteService.getWebsites(this._className, this._classPK);
    }

    @Override
    protected long getPrimaryKey(Website website) {
        return website.getWebsiteId();
    }

    @Override
    protected boolean isPrimary(Website website) {
        return website.isPrimary();
    }

    @Override
    protected void setPrimary(Website website, boolean primary) {
        website.setPrimary(primary);
    }
}

