/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.manager;

import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.service.PhoneLocalService;
import com.liferay.portal.kernel.service.PhoneService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.users.admin.kernel.util.UsersAdmin;
import com.liferay.users.admin.web.internal.manager.BaseContactInfoManager;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;

public class PhoneContactInfoManager
extends BaseContactInfoManager<Phone> {
    private final String _className;
    private final long _classPK;
    private final PhoneLocalService _phoneLocalService;
    private final PhoneService _phoneService;
    private final UsersAdmin _usersAdmin;

    public PhoneContactInfoManager(String className, long classPK, PhoneLocalService phoneLocalService, PhoneService phoneService, UsersAdmin usersAdmin) {
        this._className = className;
        this._classPK = classPK;
        this._phoneLocalService = phoneLocalService;
        this._phoneService = phoneService;
        this._usersAdmin = usersAdmin;
    }

    @Override
    public Phone construct(ActionRequest actionRequest) {
        long phoneId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"primaryKey");
        String number = ParamUtil.getString((PortletRequest)actionRequest, (String)"phoneNumber");
        String extension = ParamUtil.getString((PortletRequest)actionRequest, (String)"phoneExtension");
        long typeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"phoneTypeId");
        boolean primary = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"phonePrimary");
        Phone phone = this._phoneLocalService.createPhone(phoneId);
        phone.setNumber(number);
        phone.setExtension(extension);
        phone.setTypeId(typeId);
        phone.setPrimary(primary);
        return phone;
    }

    @Override
    public Phone doAdd(Phone phone) throws Exception {
        return this._phoneService.addPhone(this._className, this._classPK, phone.getNumber(), phone.getExtension(), phone.getTypeId(), phone.isPrimary(), new ServiceContext());
    }

    @Override
    public void doDelete(long phoneId) throws Exception {
        this._phoneService.deletePhone(phoneId);
    }

    @Override
    public void doUpdate(Phone phone) throws Exception {
        this._phoneService.updatePhone(phone.getPhoneId(), phone.getNumber(), phone.getExtension(), phone.getTypeId(), phone.isPrimary());
    }

    @Override
    public Phone get(long phoneId) throws Exception {
        return this._phoneService.getPhone(phoneId);
    }

    @Override
    public List<Phone> getAll() throws Exception {
        return this._phoneService.getPhones(this._className, this._classPK);
    }

    @Override
    public long getPrimaryKey(Phone phone) {
        return phone.getPhoneId();
    }

    @Override
    public boolean isPrimary(Phone phone) {
        return phone.isPrimary();
    }

    @Override
    public void setPrimary(Phone phone, boolean primary) {
        phone.setPrimary(primary);
    }
}

