/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.manager;

import com.liferay.users.admin.web.internal.manager.ContactInfoManager;
import java.util.List;
import javax.portlet.ActionRequest;

public abstract class BaseContactInfoManager<T>
implements ContactInfoManager<T> {
    @Override
    public void delete(long primaryKey) throws Exception {
        T contactInfo = this.get(primaryKey);
        this.doDelete(primaryKey);
        if (this.isPrimary(contactInfo)) {
            List<T> contactInfos = this.getAll();
            if (contactInfos.isEmpty()) {
                return;
            }
            this.makePrimary(contactInfos.get(0));
        }
    }

    @Override
    public void edit(ActionRequest actionRequest) throws Exception {
        T contactInfo = this.construct(actionRequest);
        if (this.getPrimaryKey(contactInfo) > 0L) {
            this.doUpdate(contactInfo);
        } else {
            contactInfo = this.doAdd(contactInfo);
        }
        List<T> contactInfos = this.getAll();
        if (contactInfos.isEmpty()) {
            return;
        }
        if (!this.hasPrimary(contactInfos)) {
            long size = contactInfos.size();
            for (T tempContactInfo : contactInfos) {
                if (size != 1L && this.getPrimaryKey(tempContactInfo) == this.getPrimaryKey(contactInfo)) continue;
                this.setPrimary(tempContactInfo, true);
                this.doUpdate(tempContactInfo);
            }
        }
    }

    @Override
    public void makePrimary(long primaryKey) throws Exception {
        this.makePrimary(this.get(primaryKey));
    }

    protected abstract T construct(ActionRequest var1) throws Exception;

    protected abstract T doAdd(T var1) throws Exception;

    protected abstract void doDelete(long var1) throws Exception;

    protected abstract void doUpdate(T var1) throws Exception;

    protected abstract T get(long var1) throws Exception;

    protected abstract List<T> getAll() throws Exception;

    protected abstract long getPrimaryKey(T var1);

    protected boolean hasPrimary(List<T> contactInfos) {
        for (T contacInfo : contactInfos) {
            if (!this.isPrimary(contacInfo)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean isPrimary(T var1);

    protected void makePrimary(T contactInfo) throws Exception {
        this.setPrimary(contactInfo, true);
        this.doUpdate(contactInfo);
    }

    protected abstract void setPrimary(T var1, boolean var2);
}

