/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.frontend.taglib.servlet.taglib;

import com.liferay.frontend.taglib.servlet.taglib.ScreenNavigationCategory;
import com.liferay.frontend.taglib.servlet.taglib.ScreenNavigationEntry;
import com.liferay.frontend.taglib.servlet.taglib.util.JSPRenderer;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletURLFactory;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.users.admin.web.internal.frontend.taglib.servlet.taglib.OrganizationScreenNavigationCategory;
import com.liferay.users.admin.web.internal.frontend.taglib.servlet.taglib.OrganizationScreenNavigationEntry;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.function.BiFunction;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={})
public class OrganizationScreenNavigationRegistrar {
    private static final String _CATEGORY_CONTACT = "contact";
    private static final String _CATEGORY_GENERAL = "general";
    private BundleContext _bundleContext;
    @Reference
    private JSPRenderer _jspRenderer;
    @Reference
    private OrganizationService _organizationService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletURLFactory _portletURLFactory;
    private final List<ServiceRegistration<ScreenNavigationCategory>> _screenNavigationCategoryServiceRegistrations = new ArrayList<ServiceRegistration<ScreenNavigationCategory>>();
    private final List<ServiceRegistration<ScreenNavigationEntry>> _screenNavigationEntryServiceRegistrations = new ArrayList<ServiceRegistration<ScreenNavigationEntry>>();

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this.registerScreenNavigationCategories();
        this.registerScreenNavigationEntries();
    }

    @Deactivate
    public void deactivate() {
        this._screenNavigationEntryServiceRegistrations.forEach(ServiceRegistration::unregister);
        this._screenNavigationEntryServiceRegistrations.clear();
        this._screenNavigationCategoryServiceRegistrations.forEach(ServiceRegistration::unregister);
        this._screenNavigationCategoryServiceRegistrations.clear();
    }

    protected void registerScreenNavigationCategories() {
        this._registerScreenNavigationCategory((ScreenNavigationCategory)new OrganizationScreenNavigationCategory(_CATEGORY_GENERAL), 10);
        this._registerScreenNavigationCategory((ScreenNavigationCategory)new OrganizationScreenNavigationCategory(_CATEGORY_CONTACT), 20);
    }

    protected void registerScreenNavigationEntries() {
        this._registerScreenNavigationEntry(this._createScreenNavigationEntry("information", _CATEGORY_GENERAL, "/organization/information.jsp", "/users_admin/edit_organization"), 10);
        this._registerScreenNavigationEntry(this._createUpdateOnlyScreenNavigationEntry("organization-site", _CATEGORY_GENERAL, "/organization/organization_site.jsp", "/users_admin/update_organization_organization_site", false, true), 20);
        this._registerScreenNavigationEntry(this._createUpdateOnlyScreenNavigationEntry("security-questions", _CATEGORY_GENERAL, "/organization/reminder_queries.jsp", "/users_admin/update_organization_reminder_queries"), 30);
        this._registerScreenNavigationEntry(this._createUpdateOnlyScreenNavigationEntry("addresses", _CATEGORY_CONTACT, "/organization/addresses.jsp", "/users_admin/update_contact_information", false, false), 10);
        this._registerScreenNavigationEntry(this._createUpdateOnlyScreenNavigationEntry("contact-information", _CATEGORY_CONTACT, "/organization/contact_information.jsp", "/users_admin/update_contact_information", false, true), 20);
        this._registerScreenNavigationEntry(this._createUpdateOnlyScreenNavigationEntry("opening-hours", _CATEGORY_CONTACT, "/organization/opening_hours.jsp", "/users_admin/update_contact_information", false, false), 30);
    }

    private ScreenNavigationEntry<Organization> _createScreenNavigationEntry(String entryKey, String categoryKey, String jspPath, String mvcActionCommandName) {
        return this._createScreenNavigationEntry(entryKey, categoryKey, jspPath, mvcActionCommandName, true, true, (user, organization) -> true);
    }

    private ScreenNavigationEntry<Organization> _createScreenNavigationEntry(String entryKey, String categoryKey, String jspPath, String mvcActionCommandName, boolean showControls, boolean showTitle, BiFunction<User, Organization, Boolean> isVisibleBiFunction) {
        return new OrganizationScreenNavigationEntry(this._jspRenderer, this._organizationService, this._portal, this._portletURLFactory, entryKey, categoryKey, jspPath, mvcActionCommandName, showControls, showTitle, isVisibleBiFunction);
    }

    private ScreenNavigationEntry<Organization> _createUpdateOnlyScreenNavigationEntry(String entryKey, String categoryKey, String jspPath, String mvcActionCommandName) {
        return this._createUpdateOnlyScreenNavigationEntry(entryKey, categoryKey, jspPath, mvcActionCommandName, true, true);
    }

    private ScreenNavigationEntry<Organization> _createUpdateOnlyScreenNavigationEntry(String entryKey, String categoryKey, String jspPath, String mvcActionCommandName, boolean showControls, boolean showTitle) {
        return this._createScreenNavigationEntry(entryKey, categoryKey, jspPath, mvcActionCommandName, showControls, showTitle, (user, organization) -> {
            if (organization == null) {
                return false;
            }
            return true;
        });
    }

    private Dictionary<String, Object> _getProperties(final Integer serviceRanking) {
        return new HashMapDictionary<String, Object>(){
            {
                if (serviceRanking != null) {
                    this.put("screen.navigation.category.order", serviceRanking);
                    this.put("screen.navigation.entry.order", serviceRanking);
                }
            }
        };
    }

    private void _registerScreenNavigationCategory(ScreenNavigationCategory screenNavigationCategory, Dictionary<String, Object> properties) {
        this._screenNavigationCategoryServiceRegistrations.add((ServiceRegistration<ScreenNavigationCategory>)this._bundleContext.registerService(ScreenNavigationCategory.class, (Object)screenNavigationCategory, properties));
    }

    private void _registerScreenNavigationCategory(ScreenNavigationCategory screenNavigationCategory, Integer serviceRanking) {
        this._registerScreenNavigationCategory(screenNavigationCategory, this._getProperties(serviceRanking));
    }

    private void _registerScreenNavigationEntry(ScreenNavigationEntry screenNavigationEntry, Dictionary<String, Object> properties) {
        this._screenNavigationEntryServiceRegistrations.add((ServiceRegistration<ScreenNavigationEntry>)this._bundleContext.registerService(ScreenNavigationEntry.class, (Object)screenNavigationEntry, properties));
    }

    private void _registerScreenNavigationEntry(ScreenNavigationEntry screenNavigationEntry, Integer serviceRanking) {
        this._registerScreenNavigationEntry(screenNavigationEntry, this._getProperties(serviceRanking));
    }
}

