/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.frontend.taglib.servlet.taglib;

import com.liferay.frontend.taglib.servlet.taglib.ScreenNavigationEntry;
import com.liferay.frontend.taglib.servlet.taglib.util.JSPRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactory;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.users.admin.web.internal.display.context.OrganizationScreenNavigationDisplayContext;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OrganizationScreenNavigationEntry
implements ScreenNavigationEntry<Organization> {
    private static final Log _log = LogFactoryUtil.getLog(OrganizationScreenNavigationEntry.class);
    private final String _categoryKey;
    private final String _entryKey;
    private final BiFunction<User, Organization, Boolean> _isVisibleBiFunction;
    private final String _jspPath;
    private final JSPRenderer _jspRenderer;
    private final String _mvcActionCommandName;
    private final OrganizationService _organizationService;
    private final Portal _portal;
    private final PortletURLFactory _portletURLFactory;
    private final boolean _showControls;
    private final boolean _showTitle;

    public OrganizationScreenNavigationEntry(JSPRenderer jspRenderer, OrganizationService organizationService, Portal portal, PortletURLFactory portletURLFactory, String entryKey, String categoryKey, String jspPath, String mvcActionCommandName, boolean showControls, boolean showTitle, BiFunction<User, Organization, Boolean> isVisibleBiFunction) {
        this._jspRenderer = jspRenderer;
        this._organizationService = organizationService;
        this._portal = portal;
        this._portletURLFactory = portletURLFactory;
        this._entryKey = entryKey;
        this._categoryKey = categoryKey;
        this._jspPath = jspPath;
        this._mvcActionCommandName = mvcActionCommandName;
        this._showControls = showControls;
        this._showTitle = showTitle;
        this._isVisibleBiFunction = isVisibleBiFunction;
    }

    public String getCategoryKey() {
        return this._categoryKey;
    }

    public String getEntryKey() {
        return this._entryKey;
    }

    public String getLabel(Locale locale) {
        return LanguageUtil.get((ResourceBundle)ResourceBundleUtil.getBundle((Locale)locale, OrganizationScreenNavigationEntry.class), (String)this._entryKey);
    }

    public String getScreenNavigationKey() {
        return "edit.organization.form";
    }

    public boolean isVisible(User user, Organization organization) {
        return this._isVisibleBiFunction.apply(user, organization);
    }

    public void render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Organization organization;
        long organizationId;
        String backURL;
        OrganizationScreenNavigationDisplayContext organizationScreenNavigationDisplayContext;
        block2: {
            organizationScreenNavigationDisplayContext = new OrganizationScreenNavigationDisplayContext();
            String redirect = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"redirect");
            backURL = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"backURL", (String)redirect);
            organizationScreenNavigationDisplayContext.setBackURL(backURL);
            organizationScreenNavigationDisplayContext.setFormLabel(this.getLabel(httpServletRequest.getLocale()));
            organizationScreenNavigationDisplayContext.setJspPath(this._jspPath);
            organizationId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"organizationId");
            organization = null;
            try {
                organization = this._organizationService.fetchOrganization(organizationId);
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        organizationScreenNavigationDisplayContext.setOrganization(organization);
        organizationScreenNavigationDisplayContext.setOrganizationId(organizationId);
        organizationScreenNavigationDisplayContext.setShowControls(this._showControls);
        organizationScreenNavigationDisplayContext.setShowTitle(this._showTitle);
        String portletId = this._portal.getPortletId(httpServletRequest);
        LiferayPortletURL editOrganizationActionURL = this._portletURLFactory.create(httpServletRequest, portletId, "ACTION_PHASE");
        editOrganizationActionURL.setParameter("javax.portlet.action", this._mvcActionCommandName);
        LiferayPortletURL editOrganizationRenderURL = this._portletURLFactory.create(httpServletRequest, portletId, "RENDER_PHASE");
        editOrganizationRenderURL.setParameter("mvcRenderCommandName", "/users_admin/edit_organization");
        editOrganizationRenderURL.setParameter("backURL", backURL);
        editOrganizationRenderURL.setParameter("organizationId", String.valueOf(organizationId));
        editOrganizationRenderURL.setParameter("screenNavigationCategoryKey", this._categoryKey);
        editOrganizationRenderURL.setParameter("screenNavigationEntryKey", this._entryKey);
        editOrganizationActionURL.setParameter("redirect", editOrganizationRenderURL.toString());
        editOrganizationActionURL.setParameter("backURL", backURL);
        editOrganizationActionURL.setParameter("organizationId", String.valueOf(organizationId));
        editOrganizationActionURL.setParameter("screenNavigationCategoryKey", this._categoryKey);
        editOrganizationActionURL.setParameter("screenNavigationEntryKey", this._entryKey);
        organizationScreenNavigationDisplayContext.setEditOrganizationActionURL(editOrganizationActionURL.toString());
        httpServletRequest.setAttribute("ORGANIZATION_SCREEN_NAVIGATION_DISPLAY_CONTEXT", (Object)organizationScreenNavigationDisplayContext);
        this._jspRenderer.renderJSP(httpServletRequest, httpServletResponse, "/edit_organization_navigation.jsp");
    }
}

