/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchResult;
import com.liferay.portal.kernel.search.SearchResultUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.users.admin.web.internal.search.OrganizationUserChecker;
import com.liferay.users.admin.web.internal.util.comparator.OrganizationUserNameComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class ViewTreeManagementToolbarDisplayContext {
    private final String _displayStyle;
    private final HttpServletRequest _httpServletRequest;
    private String _keywords;
    private String _navigation;
    private String _orderByCol;
    private String _orderByType;
    private final Organization _organization;
    private final PermissionChecker _permissionChecker;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private SearchContainer _searchContainer;

    public ViewTreeManagementToolbarDisplayContext(HttpServletRequest httpServletRequest, RenderRequest renderRequest, RenderResponse renderResponse, Organization organization, String displayStyle) {
        this._httpServletRequest = httpServletRequest;
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._organization = organization;
        this._displayStyle = displayStyle;
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._permissionChecker = themeDisplay.getPermissionChecker();
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "delete");
                    dropdownItem.setHref((Object)StringBundler.concat((String[])new String[]{"javascript:", ViewTreeManagementToolbarDisplayContext.this._renderResponse.getNamespace(), "delete();"}));
                    dropdownItem.setIcon("times-circle");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewTreeManagementToolbarDisplayContext.this._httpServletRequest, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
                if (!Objects.equals(ViewTreeManagementToolbarDisplayContext.this.getNavigation(), "active")) {
                    this.add(dropdownItem -> {
                        dropdownItem.putData("action", "restore");
                        dropdownItem.setHref((Object)StringBundler.concat((String[])new String[]{"javascript:", ViewTreeManagementToolbarDisplayContext.this._renderResponse.getNamespace(), "deleteUsers('", "restore", "');"}));
                        dropdownItem.setIcon("undo");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewTreeManagementToolbarDisplayContext.this._httpServletRequest, (String)"restore"));
                        dropdownItem.setQuickAction(true);
                    });
                }
                if (!Objects.equals(ViewTreeManagementToolbarDisplayContext.this.getNavigation(), "inactive")) {
                    this.add(dropdownItem -> {
                        dropdownItem.putData("action", "deactivate");
                        dropdownItem.setHref((Object)StringBundler.concat((String[])new String[]{"javascript:", ViewTreeManagementToolbarDisplayContext.this._renderResponse.getNamespace(), "deleteUsers('", "deactivate", "');"}));
                        dropdownItem.setIcon("hidden");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewTreeManagementToolbarDisplayContext.this._httpServletRequest, (String)"deactivate"));
                        dropdownItem.setQuickAction(true);
                    });
                }
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "remove");
                    dropdownItem.setHref((Object)StringBundler.concat((String[])new String[]{"javascript:", ViewTreeManagementToolbarDisplayContext.this._renderResponse.getNamespace(), "removeOrganizationsAndUsers();"}));
                    dropdownItem.setIcon("remove-role");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewTreeManagementToolbarDisplayContext.this._httpServletRequest, (String)"remove"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public List<String> getAvailableActions(Organization organization) {
        return Arrays.asList("delete", "remove");
    }

    public List<String> getAvailableActions(User user) {
        ArrayList<String> availableActionDropdownItems = new ArrayList<String>();
        if (user.isActive()) {
            availableActionDropdownItems.add("deactivate");
        } else {
            availableActionDropdownItems.add("delete");
            availableActionDropdownItems.add("restore");
        }
        availableActionDropdownItems.add("remove");
        return availableActionDropdownItems;
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        clearResultsURL.setParameter("navigation", (String)null);
        return clearResultsURL.toString();
    }

    public CreationMenu getCreationMenu() throws PortalException {
        final PortletURL currentURL = PortletURLUtil.getCurrent((PortletRequest)this._renderRequest, (MimeResponse)this._renderResponse);
        return new CreationMenu(){
            {
                if (ViewTreeManagementToolbarDisplayContext.this.hasAddUserPermission()) {
                    this.addDropdownItem(dropdownItem -> {
                        dropdownItem.setHref(ViewTreeManagementToolbarDisplayContext.this._renderResponse.createRenderURL(), new Object[]{"mvcRenderCommandName", "/users_admin/edit_user", "backURL", currentURL.toString(), "organizationsSearchContainerPrimaryKeys", String.valueOf(ViewTreeManagementToolbarDisplayContext.this._organization.getOrganizationId())});
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewTreeManagementToolbarDisplayContext.this._httpServletRequest, (String)"new-user"));
                    });
                }
                if (ViewTreeManagementToolbarDisplayContext.this.hasAddOrganizationPermission()) {
                    for (String organizationType : OrganizationLocalServiceUtil.getTypes()) {
                        PortletURL addOrganizationTypeURL = ViewTreeManagementToolbarDisplayContext.this._renderResponse.createRenderURL();
                        addOrganizationTypeURL.setParameter("mvcRenderCommandName", "/users_admin/edit_organization");
                        addOrganizationTypeURL.setParameter("redirect", currentURL.toString());
                        addOrganizationTypeURL.setParameter("parentOrganizationSearchContainerPrimaryKeys", String.valueOf(ViewTreeManagementToolbarDisplayContext.this._organization.getOrganizationId()));
                        addOrganizationTypeURL.setParameter("type", organizationType);
                        this.addDropdownItem(dropdownItem -> {
                            dropdownItem.setHref((Object)addOrganizationTypeURL);
                            dropdownItem.setLabel(LanguageUtil.format((HttpServletRequest)ViewTreeManagementToolbarDisplayContext.this._httpServletRequest, (String)"new-x", (Object)organizationType));
                        });
                    }
                }
                if (OrganizationPermissionUtil.contains((PermissionChecker)ViewTreeManagementToolbarDisplayContext.this._permissionChecker, (Organization)ViewTreeManagementToolbarDisplayContext.this._organization, (String)"ASSIGN_MEMBERS")) {
                    this.addDropdownItem(dropdownItem -> {
                        dropdownItem.putData("action", "selectUsers");
                        dropdownItem.putData("organizationId", String.valueOf(ViewTreeManagementToolbarDisplayContext.this._organization.getOrganizationId()));
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewTreeManagementToolbarDisplayContext.this._httpServletRequest, (String)"assign-users"));
                        dropdownItem.setQuickAction(true);
                    });
                }
            }
        };
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(ViewTreeManagementToolbarDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewTreeManagementToolbarDisplayContext.this._httpServletRequest, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(ViewTreeManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewTreeManagementToolbarDisplayContext.this._httpServletRequest, (String)"order-by"));
                });
            }
        };
    }

    public List<LabelItem> getFilterLabelItems() {
        return new LabelItemList(){
            {
                String navigation = ViewTreeManagementToolbarDisplayContext.this.getNavigation();
                if (!navigation.equals("all")) {
                    this.add(labelItem -> {
                        PortletURL removeLabelURL = ViewTreeManagementToolbarDisplayContext.this.getPortletURL();
                        removeLabelURL.setParameter("navigation", (String)null);
                        labelItem.putData("removeLabelURL", removeLabelURL.toString());
                        labelItem.setCloseable(true);
                        String label = String.format("%s: %s", LanguageUtil.get((HttpServletRequest)ViewTreeManagementToolbarDisplayContext.this._httpServletRequest, (String)"status"), LanguageUtil.get((HttpServletRequest)ViewTreeManagementToolbarDisplayContext.this._httpServletRequest, (String)navigation));
                        labelItem.setLabel(label);
                    });
                }
            }
        };
    }

    public String getKeywords() {
        if (this._keywords == null) {
            this._keywords = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords");
        }
        return this._keywords;
    }

    public String getNavigation() {
        if (this._navigation == null) {
            this._navigation = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"navigation", (String)"all");
        }
        return this._navigation;
    }

    public String getOrderByCol() {
        if (this._orderByCol == null) {
            this._orderByCol = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByCol", (String)"name");
        }
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType == null) {
            this._orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType", (String)"asc");
        }
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/users_admin/view");
        portletURL.setParameter("organizationId", String.valueOf(this._organization.getOrganizationId()));
        String toolbarItem = GetterUtil.getString((Object)this._httpServletRequest.getAttribute("view.jsp-toolbarItem"));
        portletURL.setParameter("toolbarItem", toolbarItem);
        String usersListView = GetterUtil.getString((Object)this._httpServletRequest.getAttribute("view.jsp-usersListView"));
        portletURL.setParameter("usersListView", usersListView);
        portletURL.setParameter("displayStyle", this._displayStyle);
        Object[] keywords = ParamUtil.getStringValues((HttpServletRequest)this._httpServletRequest, (String)"keywords");
        if (ArrayUtil.isNotEmpty((Object[])keywords)) {
            portletURL.setParameter("keywords", (String)keywords[keywords.length - 1]);
        }
        portletURL.setParameter("navigation", this.getNavigation());
        portletURL.setParameter("orderByCol", this.getOrderByCol());
        portletURL.setParameter("orderByType", this.getOrderByType());
        return portletURL;
    }

    public String getSearchActionURL() {
        PortletURL searchActionURL = this.getPortletURL();
        return searchActionURL.toString();
    }

    public SearchContainer getSearchContainer() throws Exception {
        if (this._searchContainer != null) {
            return this._searchContainer;
        }
        SearchContainer searchContainer = new SearchContainer((PortletRequest)this._renderRequest, PortletURLUtil.getCurrent((PortletRequest)this._renderRequest, (MimeResponse)this._renderResponse), ListUtil.fromString((String)"name,type,status"), "no-results-were-found");
        searchContainer.setOrderByCol(this.getOrderByCol());
        String orderByType = this.getOrderByType();
        searchContainer.setOrderByType(orderByType);
        OrganizationUserNameComparator orderByComparator = new OrganizationUserNameComparator(orderByType.equals("asc"));
        searchContainer.setOrderByComparator((OrderByComparator)orderByComparator);
        searchContainer.setRowChecker((RowChecker)new OrganizationUserChecker(this._renderResponse));
        int status = -1;
        if (Objects.equals(this.getNavigation(), "active")) {
            status = 0;
        } else if (Objects.equals(this.getNavigation(), "inactive")) {
            status = 5;
        }
        int total = 0;
        ArrayList<Object> results = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (Validator.isNotNull((String)this.getKeywords())) {
            total = OrganizationLocalServiceUtil.searchOrganizationsAndUsersCount((long)themeDisplay.getCompanyId(), (long)this._organization.getOrganizationId(), (String)this.getKeywords(), (int)status, null);
            Sort[] sorts = new Sort[]{new Sort("name", orderByType.equals("desc")), new Sort("lastName", orderByType.equals("desc"))};
            Hits hits = OrganizationLocalServiceUtil.searchOrganizationsAndUsers((long)themeDisplay.getCompanyId(), (long)this._organization.getOrganizationId(), (String)this.getKeywords(), (int)status, null, (int)searchContainer.getStart(), (int)searchContainer.getEnd(), (Sort[])sorts);
            results = new ArrayList<Object>(hits.getLength());
            List searchResults = SearchResultUtil.getSearchResults((Hits)hits, (Locale)themeDisplay.getLocale());
            for (SearchResult searchResult : searchResults) {
                String className = searchResult.getClassName();
                if (className.equals(Organization.class.getName())) {
                    results.add(OrganizationLocalServiceUtil.fetchOrganization((long)searchResult.getClassPK()));
                    continue;
                }
                if (!className.equals(User.class.getName())) continue;
                results.add(UserLocalServiceUtil.fetchUser((long)searchResult.getClassPK()));
            }
        } else {
            total = OrganizationLocalServiceUtil.getOrganizationsAndUsersCount((long)themeDisplay.getCompanyId(), (long)this._organization.getOrganizationId(), (int)status);
            results = OrganizationLocalServiceUtil.getOrganizationsAndUsers((long)themeDisplay.getCompanyId(), (long)this._organization.getOrganizationId(), (int)status, (int)searchContainer.getStart(), (int)searchContainer.getEnd(), (OrderByComparator)searchContainer.getOrderByComparator());
        }
        searchContainer.setTotal(total);
        searchContainer.setResults((List)results);
        this._searchContainer = searchContainer;
        return this._searchContainer;
    }

    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public List<ViewTypeItem> getViewTypeItems() {
        return new ViewTypeItemList(this.getPortletURL(), this._displayStyle){
            {
                this.addCardViewTypeItem();
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    public boolean hasAddOrganizationPermission() {
        return PortalPermissionUtil.contains((PermissionChecker)this._permissionChecker, (String)"ADD_ORGANIZATION");
    }

    public boolean hasAddUserPermission() {
        return PortalPermissionUtil.contains((PermissionChecker)this._permissionChecker, (String)"ADD_USER");
    }

    public boolean showCreationMenu() throws PortalException {
        return this.hasAddOrganizationPermission() || this.hasAddUserPermission();
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        DropdownItemList navigationDropdownitems = new DropdownItemList();
        for (String navigation : new String[]{"all", "active", "inactive"}) {
            navigationDropdownitems.add(dropdownItem -> {
                dropdownItem.setActive(Objects.equals(this.getNavigation(), navigation));
                dropdownItem.setHref(this.getPortletURL(), new Object[]{"navigation", navigation});
                dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)navigation));
            });
        }
        return navigationDropdownitems;
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref((Object)"");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewTreeManagementToolbarDisplayContext.this._httpServletRequest, (String)"name"));
                });
            }
        };
    }
}

