/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.display.context;

import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.model.OrgLabor;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.text.Format;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

public class OrgLaborFormDisplay {
    private static final String[] _SHORT_DAY_NAMES = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
    private final List<DayRowDisplay> _dayRowDisplays;
    private final Format _timeFormat;

    public OrgLaborFormDisplay(Locale locale, OrgLabor orgLabor) {
        this._timeFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"HH:mm", (Locale)locale);
        this._dayRowDisplays = this._buildDayRowDisplays(locale, orgLabor);
    }

    public List<DayRowDisplay> getDayRowDisplays() {
        return this._dayRowDisplays;
    }

    private List<DayRowDisplay> _buildDayRowDisplays(Locale locale, OrgLabor orgLabor) {
        ArrayList<DayRowDisplay> dayRowDisplays = new ArrayList<DayRowDisplay>();
        String[] days = CalendarUtil.getDays((Locale)locale);
        for (int i = 0; i < _SHORT_DAY_NAMES.length; ++i) {
            String longDayName = days[i];
            String shortDayName = _SHORT_DAY_NAMES[i];
            List<SelectOptionDisplay> closeSelectOptionDisplays = this._buildSelectOptionDisplays(locale, BeanPropertiesUtil.getInteger((Object)orgLabor, (String)(shortDayName + "Close"), (int)-1));
            List<SelectOptionDisplay> openSelectOptionDisplays = this._buildSelectOptionDisplays(locale, BeanPropertiesUtil.getInteger((Object)orgLabor, (String)(shortDayName + "Open"), (int)-1));
            dayRowDisplays.add(new DayRowDisplay(longDayName, shortDayName, closeSelectOptionDisplays, openSelectOptionDisplays));
        }
        return dayRowDisplays;
    }

    private List<SelectOptionDisplay> _buildSelectOptionDisplays(Locale locale, int time) {
        ArrayList<SelectOptionDisplay> selectOptionDisplays = new ArrayList<SelectOptionDisplay>();
        Format timeFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"HH:mm", (Locale)locale);
        Calendar calendar = CalendarFactoryUtil.getCalendar();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        int today = calendar.get(5);
        while (calendar.get(5) == today) {
            int timeOfDayValue = GetterUtil.getInteger((String)StringUtil.replace((String)timeFormat.format(calendar.getTime()), (char)':', (String)""));
            selectOptionDisplays.add(new SelectOptionDisplay(timeFormat.format(calendar.getTime()), timeOfDayValue, time == timeOfDayValue));
            calendar.add(12, 30);
        }
        return selectOptionDisplays;
    }

    public class SelectOptionDisplay {
        private final String _label;
        private final boolean _selected;
        private final int _value;

        public SelectOptionDisplay(String label, int value, boolean selected) {
            this._label = label;
            this._value = value;
            this._selected = selected;
        }

        public String getLabel() {
            return this._label;
        }

        public int getValue() {
            return this._value;
        }

        public boolean isSelected() {
            return this._selected;
        }
    }

    public class DayRowDisplay {
        private final List<SelectOptionDisplay> _closeSelectOptionDisplays;
        private final String _longDayName;
        private final List<SelectOptionDisplay> _openSelectOptionDisplays;
        private final String _shortDayName;

        public DayRowDisplay(String longDayName, String shortDayName, List<SelectOptionDisplay> closeSelectOptionDisplays, List<SelectOptionDisplay> openSelectOptionDisplays) {
            this._longDayName = longDayName;
            this._shortDayName = shortDayName;
            this._closeSelectOptionDisplays = closeSelectOptionDisplays;
            this._openSelectOptionDisplays = openSelectOptionDisplays;
        }

        public List<SelectOptionDisplay> getCloseSelectOptionDisplays() {
            return this._closeSelectOptionDisplays;
        }

        public String getLongDayName() {
            return this._longDayName;
        }

        public List<SelectOptionDisplay> getOpenSelectOptionDisplays() {
            return this._openSelectOptionDisplays;
        }

        public String getShortDayName() {
            return this._shortDayName;
        }
    }
}

