/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.display.context;

import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.OrgLabor;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.Format;
import java.util.Calendar;
import java.util.Locale;

public class OrgLaborDisplay {
    private static final String[] _SHORT_DAY_NAMES = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
    private final KeyValuePair[] _dayKeyValuePairs;
    private final String _title;

    public OrgLaborDisplay(Locale locale, OrgLabor orgLabor) throws Exception {
        ListType listType = orgLabor.getType();
        this._title = LanguageUtil.get((Locale)locale, (String)StringUtil.toUpperCase((String)listType.getName()));
        this._dayKeyValuePairs = this._buildDayKeyValuePairs(locale, orgLabor);
    }

    public KeyValuePair[] getDayKeyValuePairs() {
        return this._dayKeyValuePairs;
    }

    public String getTitle() {
        return this._title;
    }

    private KeyValuePair[] _buildDayKeyValuePairs(Locale locale, OrgLabor orgLabor) {
        KeyValuePair[] dayKeyValuePairs = new KeyValuePair[7];
        String[] longDayNames = CalendarUtil.getDays((Locale)locale);
        for (int i = 0; i < _SHORT_DAY_NAMES.length; ++i) {
            dayKeyValuePairs[i] = new KeyValuePair(longDayNames[i], this._getHoursDisplayValue(locale, orgLabor, _SHORT_DAY_NAMES[i]));
        }
        return dayKeyValuePairs;
    }

    private String _formatHourAndMinute(Locale locale, int hourAndMinute) {
        if (hourAndMinute < 0) {
            return "";
        }
        Calendar calendar = CalendarFactoryUtil.getCalendar();
        calendar.set(14, 0);
        calendar.set(13, 0);
        String hourAndMinuteString = String.valueOf(hourAndMinute);
        if (hourAndMinuteString.length() == 4) {
            calendar.set(11, Integer.valueOf(hourAndMinuteString.substring(0, 2)));
            calendar.set(12, Integer.valueOf(hourAndMinuteString.substring(2)));
        } else if (hourAndMinuteString.length() == 3) {
            calendar.set(11, hourAndMinuteString.charAt(0));
            calendar.set(12, Integer.valueOf(hourAndMinuteString.substring(1)));
        } else {
            calendar.set(11, 0);
            calendar.set(12, 0);
        }
        Format format = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"HH:mm", (Locale)locale);
        return format.format(calendar.getTime());
    }

    private String _getHoursDisplayValue(Locale locale, OrgLabor orgLabor, String shortDayName) {
        String closeHourAndMinuteString = this._formatHourAndMinute(locale, BeanPropertiesUtil.getInteger((Object)orgLabor, (String)(shortDayName + "Close"), (int)-1));
        String openHourAndMinuteString = this._formatHourAndMinute(locale, BeanPropertiesUtil.getInteger((Object)orgLabor, (String)(shortDayName + "Open"), (int)-1));
        if (Validator.isNull((String)closeHourAndMinuteString) && Validator.isNull((String)openHourAndMinuteString)) {
            return LanguageUtil.get((Locale)locale, (String)"closed");
        }
        return openHourAndMinuteString + " - " + closeHourAndMinuteString;
    }
}

