/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.membershippolicy.MembershipPolicyException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.users.admin.kernel.util.UsersAdmin;
import java.util.Calendar;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_my_account_web_portlet_MyAccountPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_MyOrganizationsPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_UsersAdminPortlet", "mvc.command.name=/users_admin/update_user_roles"}, service={MVCActionCommand.class})
public class UpdateUserRolesMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private Portal _portal;
    @Reference
    private UsersAdmin _usersAdmin;
    @Reference
    private UserService _userService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            User user = this._portal.getSelectedUser((PortletRequest)actionRequest);
            Contact contact = user.getContact();
            Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
            birthdayCal.setTime(user.getBirthday());
            long[] roleIds = this._usersAdmin.getRoleIds((PortletRequest)actionRequest);
            List userGroupRoles = null;
            String addGroupRolesGroupIds = actionRequest.getParameter("addGroupRolesGroupIds");
            String addGroupRolesRoleIds = actionRequest.getParameter("addGroupRolesRoleIds");
            String deleteGroupRolesGroupIds = actionRequest.getParameter("deleteGroupRolesGroupIds");
            String deleteGroupRolesRoleIds = actionRequest.getParameter("deleteGroupRolesRoleIds");
            if (addGroupRolesGroupIds != null || addGroupRolesRoleIds != null || deleteGroupRolesGroupIds != null || deleteGroupRolesRoleIds != null) {
                userGroupRoles = this._usersAdmin.getUserGroupRoles((PortletRequest)actionRequest);
            }
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)User.class.getName(), (PortletRequest)actionRequest);
            this._userService.updateUser(user.getUserId(), user.getPassword(), null, null, user.isPasswordReset(), null, null, user.getScreenName(), user.getEmailAddress(), user.getFacebookId(), user.getOpenId(), user.getLanguageId(), user.getTimeZoneId(), user.getGreeting(), user.getComments(), user.getFirstName(), user.getMiddleName(), user.getLastName(), contact.getPrefixId(), contact.getSuffixId(), user.isMale(), birthdayCal.get(2), birthdayCal.get(5), birthdayCal.get(1), contact.getSmsSn(), contact.getFacebookSn(), contact.getJabberSn(), contact.getSkypeSn(), contact.getTwitterSn(), user.getJobTitle(), user.getGroupIds(), user.getOrganizationIds(), roleIds, userGroupRoles, user.getUserGroupIds(), serviceContext);
        }
        catch (Exception e) {
            if (e instanceof NoSuchUserException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            if (e instanceof MembershipPolicyException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                actionResponse.setRenderParameter("mvcPath", "/edit_user.jsp");
            }
            throw e;
        }
    }
}

