/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.portlet.action;

import com.liferay.announcements.kernel.model.AnnouncementsDelivery;
import com.liferay.announcements.kernel.service.AnnouncementsDeliveryLocalService;
import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.exception.CompanyMaxUsersException;
import com.liferay.portal.kernel.exception.ContactBirthdayException;
import com.liferay.portal.kernel.exception.ContactNameException;
import com.liferay.portal.kernel.exception.GroupFriendlyURLException;
import com.liferay.portal.kernel.exception.NoSuchListTypeException;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.RequiredUserException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.exception.UserFieldException;
import com.liferay.portal.kernel.exception.UserIdException;
import com.liferay.portal.kernel.exception.UserReminderQueryException;
import com.liferay.portal.kernel.exception.UserScreenNameException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.DynamicActionRequest;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.membershippolicy.MembershipPolicyException;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.InvokerPortletUtil;
import com.liferay.portlet.admin.util.AdminUtil;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_users_admin_web_portlet_MyOrganizationsPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_UsersAdminPortlet", "mvc.command.name=/users_admin/edit_user"}, service={MVCActionCommand.class})
public class EditUserMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    protected Http http;
    @Reference
    protected Portal portal;
    protected UserLocalService userLocalService;
    private DLAppLocalService _dlAppLocalService;
    private ListTypeLocalService _listTypeLocalService;
    private UserService _userService;

    protected User addUser(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        boolean autoScreenName = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"autoScreenName");
        String screenName = ParamUtil.getString((PortletRequest)actionRequest, (String)"screenName");
        String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
        long facebookId = 0L;
        String languageId = ParamUtil.getString((PortletRequest)actionRequest, (String)"languageId");
        String firstName = ParamUtil.getString((PortletRequest)actionRequest, (String)"firstName");
        String middleName = ParamUtil.getString((PortletRequest)actionRequest, (String)"middleName");
        String lastName = ParamUtil.getString((PortletRequest)actionRequest, (String)"lastName");
        long prefixId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"prefixId");
        long suffixId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"suffixId");
        boolean male = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"male", (boolean)true);
        int birthdayMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayMonth");
        int birthdayDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayDay");
        int birthdayYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayYear");
        String comments = ParamUtil.getString((PortletRequest)actionRequest, (String)"comments");
        String jobTitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"jobTitle");
        long[] organizationIds = UsersAdminUtil.getOrganizationIds((PortletRequest)actionRequest);
        boolean sendEmail = true;
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)User.class.getName(), (PortletRequest)actionRequest);
        User user = this._userService.addUser(themeDisplay.getCompanyId(), true, null, null, autoScreenName, screenName, emailAddress, facebookId, null, LocaleUtil.fromLanguageId((String)languageId), firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, null, organizationIds, null, null, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), sendEmail, serviceContext);
        user.setComments(comments);
        user = this.userLocalService.updateUser(user);
        return user;
    }

    protected void deleteRole(ActionRequest actionRequest) throws Exception {
        User user = this.portal.getSelectedUser((PortletRequest)actionRequest);
        long roleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"roleId");
        this._userService.deleteRoleUser(roleId, user.getUserId());
    }

    protected void deleteUsers(ActionRequest actionRequest) throws Exception {
        long[] deleteUserIds;
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        for (long deleteUserId : deleteUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteUserIds"), (long)0L)) {
            if (cmd.equals("deactivate") || cmd.equals("restore")) {
                int status = 0;
                if (cmd.equals("deactivate")) {
                    status = 5;
                }
                this._userService.updateStatus(deleteUserId, status, new ServiceContext());
                continue;
            }
            this._userService.deleteUser(deleteUserId);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        actionRequest = this._wrapActionRequest(actionRequest);
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            Group scopeGroup;
            User user = null;
            String oldScreenName = "";
            boolean updateLanguageId = false;
            if (cmd.equals("add")) {
                user = this.addUser(actionRequest);
                SessionMessages.add((PortletRequest)actionRequest, (String)"userAdded");
            } else if (cmd.equals("deactivate") || cmd.equals("delete") || cmd.equals("restore")) {
                this.deleteUsers(actionRequest);
            } else if (cmd.equals("deleteRole")) {
                this.deleteRole(actionRequest);
            } else if (cmd.equals("update")) {
                Object[] returnValue = this.updateUser(actionRequest, actionResponse);
                user = (User)returnValue[0];
                oldScreenName = (String)returnValue[1];
                updateLanguageId = (Boolean)returnValue[2];
            } else if (cmd.equals("unlock")) {
                user = this.updateLockout(actionRequest);
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            if (user != null) {
                Group group;
                if (Validator.isNotNull((String)oldScreenName) && (group = user.getGroup()).getGroupId() == themeDisplay.getScopeGroupId()) {
                    Layout layout = themeDisplay.getLayout();
                    String friendlyURLPath = group.getPathFriendlyURL(layout.isPrivateLayout(), themeDisplay);
                    String oldPath = friendlyURLPath + "/" + oldScreenName;
                    String newPath = friendlyURLPath + "/" + user.getScreenName();
                    redirect = StringUtil.replace((String)redirect, (String)oldPath, (String)newPath);
                    redirect = StringUtil.replace((String)redirect, (String)URLCodec.encodeURL((String)oldPath), (String)URLCodec.encodeURL((String)newPath));
                }
                if (updateLanguageId && themeDisplay.isI18n()) {
                    String i18nLanguageId = user.getLanguageId();
                    int pos = i18nLanguageId.indexOf(95);
                    if (pos != -1) {
                        i18nLanguageId = i18nLanguageId.substring(0, pos);
                    }
                    String i18nPath = "/" + i18nLanguageId;
                    redirect = StringUtil.replace((String)redirect, (String)themeDisplay.getI18nPath(), (String)i18nPath);
                }
                redirect = this.http.setParameter(redirect, actionResponse.getNamespace() + "p_u_i_d", user.getUserId());
            }
            if ((scopeGroup = themeDisplay.getScopeGroup()).isUser() && this.userLocalService.fetchUserById(scopeGroup.getClassPK()) == null) {
                redirect = this.http.setParameter(redirect, "doAsGroupId", 0);
                redirect = this.http.setParameter(redirect, "refererPlid", 0);
            }
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e) {
            String mvcPath = "/edit_user.jsp";
            if (e instanceof NoSuchUserException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                mvcPath = "/error.jsp";
            } else if (e instanceof AssetCategoryException || e instanceof AssetTagException || e instanceof CompanyMaxUsersException || e instanceof ContactBirthdayException || e instanceof ContactNameException || e instanceof GroupFriendlyURLException || e instanceof MembershipPolicyException || e instanceof NoSuchListTypeException || e instanceof RequiredUserException || e instanceof UserEmailAddressException || e instanceof UserFieldException || e instanceof UserIdException || e instanceof UserReminderQueryException || e instanceof UserScreenNameException) {
                String redirect;
                if (e instanceof NoSuchListTypeException) {
                    NoSuchListTypeException nslte = (NoSuchListTypeException)e;
                    Class<?> clazz = e.getClass();
                    SessionErrors.add((PortletRequest)actionRequest, (String)(clazz.getName() + nslte.getType()));
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                }
                if ((e instanceof CompanyMaxUsersException || e instanceof RequiredUserException) && Validator.isNotNull((String)(redirect = this.portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"))))) {
                    this.sendRedirect(actionRequest, actionResponse, redirect);
                    return;
                }
            } else {
                throw e;
            }
            actionResponse.setRenderParameter("mvcPath", mvcPath);
        }
    }

    @Deprecated
    protected List<AnnouncementsDelivery> getAnnouncementsDeliveries(ActionRequest actionRequest) {
        return null;
    }

    @Deprecated
    protected List<AnnouncementsDelivery> getAnnouncementsDeliveries(ActionRequest actionRequest, User user) throws Exception {
        return null;
    }

    protected long getListTypeId(PortletRequest portletRequest, String parameterName, String type) throws Exception {
        String parameterValue = ParamUtil.getString((PortletRequest)portletRequest, (String)parameterName);
        ListType listType = this._listTypeLocalService.addListType(parameterValue, type);
        return listType.getListTypeId();
    }

    @Deprecated
    protected void setAnnouncementsDeliveryLocalService(AnnouncementsDeliveryLocalService announcementsDeliveryLocalService) {
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }

    @Reference(unbind="-")
    protected void setListTypeLocalService(ListTypeLocalService listTypeLocalService) {
        this._listTypeLocalService = listTypeLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this.userLocalService = userLocalService;
    }

    @Reference(unbind="-")
    protected void setUserService(UserService userService) {
        this._userService = userService;
    }

    protected User updateLockout(ActionRequest actionRequest) throws Exception {
        User user = this.portal.getSelectedUser((PortletRequest)actionRequest);
        this._userService.updateLockoutById(user.getUserId(), false);
        return user;
    }

    protected Object[] updateUser(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Company company;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = this.portal.getSelectedUser((PortletRequest)actionRequest);
        Contact contact = user.getContact();
        String oldPassword = AdminUtil.getUpdateUserPassword((ActionRequest)actionRequest, (long)user.getUserId());
        String oldScreenName = user.getScreenName();
        String screenName = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"screenName");
        String oldEmailAddress = user.getEmailAddress();
        String emailAddress = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"emailAddress");
        long facebookId = user.getFacebookId();
        boolean deleteLogo = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"deleteLogo");
        byte[] portraitBytes = null;
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        if (fileEntryId > 0L) {
            FileEntry fileEntry = this._dlAppLocalService.getFileEntry(fileEntryId);
            portraitBytes = FileUtil.getBytes((InputStream)fileEntry.getContentStream());
        }
        String languageId = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"languageId");
        String firstName = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"firstName");
        String middleName = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"middleName");
        String lastName = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"lastName");
        long prefixId = BeanParamUtil.getInteger((Object)contact, (PortletRequest)actionRequest, (String)"prefixId");
        long suffixId = BeanParamUtil.getInteger((Object)contact, (PortletRequest)actionRequest, (String)"suffixId");
        boolean male = BeanParamUtil.getBoolean((Object)user, (PortletRequest)actionRequest, (String)"male", (boolean)true);
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(contact.getBirthday());
        int birthdayMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayMonth", (int)birthdayCal.get(2));
        int birthdayDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayDay", (int)birthdayCal.get(5));
        int birthdayYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayYear", (int)birthdayCal.get(1));
        String comments = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"comments");
        String jobTitle = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"jobTitle");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)User.class.getName(), (PortletRequest)actionRequest);
        user = this._userService.updateUser(user.getUserId(), oldPassword, null, null, user.isPasswordReset(), null, null, screenName, emailAddress, facebookId, user.getOpenId(), !deleteLogo, portraitBytes, languageId, user.getTimeZoneId(), user.getGreeting(), comments, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, null, null, null, null, null, jobTitle, null, null, null, null, null, null, null, null, null, null, serviceContext);
        if (oldScreenName.equals(user.getScreenName())) {
            oldScreenName = "";
        }
        boolean updateLanguageId = false;
        if (user.getUserId() == themeDisplay.getUserId()) {
            HttpServletRequest request = this.portal.getOriginalServletRequest(this.portal.getHttpServletRequest((PortletRequest)actionRequest));
            HttpServletResponse response = this.portal.getHttpServletResponse((PortletResponse)actionResponse);
            HttpSession session = request.getSession();
            session.removeAttribute("org.apache.struts.action.LOCALE");
            Locale locale = LocaleUtil.fromLanguageId((String)languageId);
            LanguageUtil.updateCookie((HttpServletRequest)request, (HttpServletResponse)response, (Locale)locale);
            PortletSession portletSession = actionRequest.getPortletSession();
            InvokerPortletUtil.clearResponses((PortletSession)portletSession);
            updateLanguageId = true;
        }
        if ((company = this.portal.getCompany((PortletRequest)actionRequest)).isStrangersVerify() && !StringUtil.equalsIgnoreCase((String)oldEmailAddress, (String)emailAddress)) {
            SessionMessages.add((PortletRequest)actionRequest, (String)"verificationEmailSent");
        }
        return new Object[]{user, oldScreenName, updateLanguageId};
    }

    private ActionRequest _wrapActionRequest(ActionRequest actionRequest) throws Exception {
        DynamicActionRequest dynamicActionRequest = new DynamicActionRequest(actionRequest);
        long prefixId = this.getListTypeId((PortletRequest)actionRequest, "prefixValue", ListTypeConstants.CONTACT_PREFIX);
        dynamicActionRequest.setParameter("prefixId", String.valueOf(prefixId));
        long suffixId = this.getListTypeId((PortletRequest)actionRequest, "suffixValue", ListTypeConstants.CONTACT_SUFFIX);
        dynamicActionRequest.setParameter("suffixId", String.valueOf(suffixId));
        return dynamicActionRequest;
    }
}

