/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.PasswordPolicyLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import com.liferay.users.admin.web.internal.display.context.InitDisplayContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class UserDisplayContext {
    private final InitDisplayContext _initDisplayContext;
    private final PermissionChecker _permissionChecker;
    private final RenderResponse _renderResponse;
    private final HttpServletRequest _request;
    private final User _selUser;
    private final ThemeDisplay _themeDisplay;

    public UserDisplayContext(HttpServletRequest request, InitDisplayContext initDisplayContext) throws PortalException {
        this._request = request;
        this._initDisplayContext = initDisplayContext;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._permissionChecker = themeDisplay.getPermissionChecker();
        this._renderResponse = (RenderResponse)this._request.getAttribute("javax.portlet.response");
        this._selUser = PortalUtil.getSelectedUser((HttpServletRequest)request);
        this._themeDisplay = themeDisplay;
    }

    public List<Group> getAllGroups() throws PortalException {
        ArrayList<Group> allGroups = new ArrayList<Group>();
        allGroups.addAll(this.getGroups());
        allGroups.addAll(this.getInheritedSites());
        allGroups.addAll(this._getOrganizationRelatedGroups());
        allGroups.addAll(GroupLocalServiceUtil.getOrganizationsGroups(this.getOrganizations()));
        allGroups.addAll(GroupLocalServiceUtil.getUserGroupsGroups(this.getUserGroups()));
        return allGroups;
    }

    public Contact getContact() throws PortalException {
        if (this._selUser != null) {
            return this._selUser.getContact();
        }
        return null;
    }

    public List<Group> getGroups() throws PortalException {
        List groups = Collections.emptyList();
        if (this._selUser != null) {
            groups = this._selUser.getGroups();
            if (this._initDisplayContext.isFilterManageableGroups()) {
                groups = UsersAdminUtil.filterGroups((PermissionChecker)this._themeDisplay.getPermissionChecker(), (List)groups);
            }
        }
        return groups;
    }

    public List<UserGroupGroupRole> getInheritedSiteRoles() {
        List inheritedSiteRoles = Collections.emptyList();
        if (this._selUser != null) {
            inheritedSiteRoles = UserGroupGroupRoleLocalServiceUtil.getUserGroupGroupRolesByUser((long)this._selUser.getUserId());
        }
        return inheritedSiteRoles;
    }

    public List<Group> getInheritedSites() throws PortalException {
        List inheritedSites = GroupLocalServiceUtil.getUserGroupsRelatedGroups(this.getUserGroups());
        for (Group group : this._getOrganizationRelatedGroups()) {
            if (inheritedSites.contains(group)) continue;
            inheritedSites.add(group);
        }
        return inheritedSites;
    }

    public List<NavigationItem> getNavigationItems(final String label) {
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref((Object)"");
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)UserDisplayContext.this._request, (String)label));
                });
            }
        };
    }

    public List<UserGroupRole> getOrganizationRoles() throws PortalException {
        List<UserGroupRole> userGroupRoles = this.getUserGroupRoles();
        Stream<Object> stream = userGroupRoles.stream();
        stream = stream.filter(this::_isOrganizationRole);
        return stream.collect(Collectors.toList());
    }

    public List<Organization> getOrganizations() throws PortalException {
        List organizations = Collections.emptyList();
        if (this._selUser != null) {
            organizations = this._selUser.getOrganizations();
            if (this._initDisplayContext.isFilterManageableOrganizations()) {
                organizations = UsersAdminUtil.filterOrganizations((PermissionChecker)this._themeDisplay.getPermissionChecker(), (List)organizations);
            }
        } else {
            String organizationIds = ParamUtil.getString((HttpServletRequest)this._request, (String)"organizationsSearchContainerPrimaryKeys");
            if (Validator.isNotNull((String)organizationIds)) {
                long[] organizationIdsArray = StringUtil.split((String)organizationIds, (long)0L);
                organizations = OrganizationLocalServiceUtil.getOrganizations((long[])organizationIdsArray);
            }
        }
        return organizations;
    }

    public PasswordPolicy getPasswordPolicy() throws PortalException {
        if (this._selUser != null) {
            return this._selUser.getPasswordPolicy();
        }
        return PasswordPolicyLocalServiceUtil.getDefaultPasswordPolicy((long)this._themeDisplay.getCompanyId());
    }

    public List<Group> getRoleGroups() throws PortalException {
        List<Group> allGroups = this.getAllGroups();
        Stream<Object> stream = allGroups.stream();
        stream = stream.filter(group -> RoleLocalServiceUtil.hasGroupRoles((long)group.getGroupId()));
        return stream.collect(Collectors.toList());
    }

    public List<Role> getRoles() throws PortalException {
        List roles = Collections.emptyList();
        if (this._selUser != null) {
            roles = this._selUser.getRoles();
            if (this._initDisplayContext.isFilterManageableRoles()) {
                roles = UsersAdminUtil.filterRoles((PermissionChecker)this._permissionChecker, (List)roles);
            }
        }
        return roles;
    }

    public User getSelectedUser() {
        return this._selUser;
    }

    public List<UserGroupRole> getSiteRoles() throws PortalException {
        List<UserGroupRole> userGroupRoles = this.getUserGroupRoles();
        Stream<Object> stream = userGroupRoles.stream();
        stream = stream.filter(this::_isSiteRole);
        return stream.collect(Collectors.toList());
    }

    public List<UserGroupRole> getUserGroupRoles() throws PortalException {
        List userGroupRoles = Collections.emptyList();
        if (this._selUser != null) {
            userGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)this._selUser.getUserId());
            if (this._initDisplayContext.isFilterManageableUserGroupRoles()) {
                userGroupRoles = UsersAdminUtil.filterUserGroupRoles((PermissionChecker)this._permissionChecker, (List)userGroupRoles);
            }
        }
        return userGroupRoles;
    }

    public List<UserGroup> getUserGroups() throws PortalException {
        List userGroups = Collections.emptyList();
        if (this._selUser != null) {
            userGroups = this._selUser.getUserGroups();
            if (this._initDisplayContext.isFilterManageableUserGroups()) {
                userGroups = UsersAdminUtil.filterUserGroups((PermissionChecker)this._permissionChecker, (List)userGroups);
            }
        }
        return userGroups;
    }

    public List<NavigationItem> getViewNavigationItems(final String portletName) {
        return new NavigationItemList(){
            {
                String toolbarItem = ParamUtil.getString((HttpServletRequest)UserDisplayContext.this._request, (String)"toolbarItem", (String)"view-all-users");
                if (!portletName.equals("com_liferay_users_admin_web_portlet_MyOrganizationsPortlet")) {
                    this.add(navigationItem -> {
                        navigationItem.setActive(toolbarItem.equals("view-all-users"));
                        navigationItem.setHref(UserDisplayContext.this._renderResponse.createRenderURL(), new Object[]{"toolbarItem", "view-all-users", "saveUsersListView", true, "usersListView", "flat-users"});
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)UserDisplayContext.this._request, (String)"users"));
                    });
                }
                this.add(navigationItem -> {
                    navigationItem.setActive(toolbarItem.equals("view-all-organizations"));
                    navigationItem.setHref(UserDisplayContext.this._renderResponse.createRenderURL(), new Object[]{"toolbarItem", "view-all-organizations", "saveUsersListView", true, "usersListView", "flat-organizations"});
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)UserDisplayContext.this._request, (String)"organizations"));
                });
            }
        };
    }

    private List<Group> _getOrganizationRelatedGroups() throws PortalException {
        List organizationsRelatedGroups = Collections.emptyList();
        List<Organization> organizations = this.getOrganizations();
        if (!organizations.isEmpty()) {
            organizationsRelatedGroups = GroupLocalServiceUtil.getOrganizationsRelatedGroups(organizations);
        }
        return organizationsRelatedGroups;
    }

    private boolean _isOrganizationRole(UserGroupRole userGroupRole) {
        long roleId = userGroupRole.getRoleId();
        Role role = RoleLocalServiceUtil.fetchRole((long)roleId);
        return role != null && role.getType() == 3;
    }

    private boolean _isSiteRole(UserGroupRole userGroupRole) {
        long roleId = userGroupRole.getRoleId();
        Role role = RoleLocalServiceUtil.fetchRole((long)roleId);
        return role != null && role.getType() == 2;
    }
}

