/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.DuplicateOpenIdException;
import com.liferay.portal.kernel.exception.EmailAddressException;
import com.liferay.portal.kernel.exception.NoSuchListTypeException;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PhoneNumberException;
import com.liferay.portal.kernel.exception.PhoneNumberExtensionException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.exception.UserSmsException;
import com.liferay.portal.kernel.exception.WebsiteURLException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ContactLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.users.admin.kernel.util.UsersAdmin;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_my_account_web_portlet_MyAccountPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_MyOrganizationsPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_UsersAdminPortlet", "mvc.command.name=/users_admin/update_contact_information"}, service={MVCActionCommand.class})
public class UpdateContactInformationMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ContactLocalService _contactLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private UsersAdmin _usersAdmin;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            User user = this._portal.getSelectedUser((PortletRequest)actionRequest);
            UserPermissionUtil.check((PermissionChecker)themeDisplay.getPermissionChecker(), (long)user.getUserId(), (String)"UPDATE");
            List emailAddresses = this._usersAdmin.getEmailAddresses(actionRequest);
            List phones = this._usersAdmin.getPhones(actionRequest);
            List websites = this._usersAdmin.getWebsites(actionRequest);
            if (emailAddresses != null) {
                this._usersAdmin.updateEmailAddresses(Contact.class.getName(), user.getContactId(), emailAddresses);
            }
            if (phones != null) {
                this._usersAdmin.updatePhones(Contact.class.getName(), user.getContactId(), phones);
            }
            if (websites != null) {
                this._usersAdmin.updateWebsites(Contact.class.getName(), user.getContactId(), websites);
            }
            String facebookSn = ParamUtil.getString((PortletRequest)actionRequest, (String)"facebookSn");
            String jabberSn = ParamUtil.getString((PortletRequest)actionRequest, (String)"jabberSn");
            String skypeSn = ParamUtil.getString((PortletRequest)actionRequest, (String)"skypeSn");
            String smsSn = ParamUtil.getString((PortletRequest)actionRequest, (String)"smsSn");
            String twitterSn = ParamUtil.getString((PortletRequest)actionRequest, (String)"twitterSn");
            this._updateContact(user, facebookSn, jabberSn, skypeSn, smsSn, twitterSn);
            String openId = ParamUtil.getString((PortletRequest)actionRequest, (String)"openId");
            this._validateOpenId(user.getCompanyId(), user.getUserId(), openId);
            this._userLocalService.updateOpenId(user.getUserId(), openId);
            String redirect = this._portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e) {
            if (e instanceof NoSuchUserException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            if (e instanceof DuplicateOpenIdException || e instanceof EmailAddressException || e instanceof NoSuchListTypeException || e instanceof PhoneNumberException || e instanceof PhoneNumberExtensionException || e instanceof UserEmailAddressException || e instanceof UserSmsException || e instanceof WebsiteURLException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                actionResponse.setRenderParameter("mvcPath", "/edit_user.jsp");
            }
            throw e;
        }
    }

    private void _updateContact(User user, String facebookSn, String jabberSn, String skypeSn, String smsSn, String twitterSn) throws Exception {
        facebookSn = StringUtil.toLowerCase((String)StringUtil.trim((String)facebookSn));
        jabberSn = StringUtil.toLowerCase((String)StringUtil.trim((String)jabberSn));
        skypeSn = StringUtil.toLowerCase((String)StringUtil.trim((String)skypeSn));
        twitterSn = StringUtil.toLowerCase((String)StringUtil.trim((String)twitterSn));
        if (Validator.isNotNull((String)smsSn) && !Validator.isEmailAddress((String)smsSn)) {
            throw new UserSmsException.MustBeEmailAddress(smsSn);
        }
        Contact contact = user.fetchContact();
        if (contact == null) {
            contact = this._contactLocalService.createContact(user.getContactId());
            contact.setCompanyId(user.getCompanyId());
            contact.setUserName("");
            contact.setClassName(User.class.getName());
            contact.setClassPK(user.getUserId());
            Company company = this._companyLocalService.getCompany(user.getCompanyId());
            contact.setAccountId(company.getAccountId());
            contact.setParentContactId(0L);
        }
        contact.setSmsSn(smsSn);
        contact.setFacebookSn(facebookSn);
        contact.setJabberSn(jabberSn);
        contact.setSkypeSn(skypeSn);
        contact.setTwitterSn(twitterSn);
        this._contactLocalService.updateContact(contact);
    }

    private void _validateOpenId(long companyId, long userId, String openId) throws Exception {
        if (Validator.isNull((String)openId)) {
            return;
        }
        User user = this._userLocalService.fetchUserByOpenId(companyId, openId);
        if (user != null && user.getUserId() != userId) {
            throw new DuplicateOpenIdException("{userId=" + userId + "}");
        }
    }
}

