/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.portlet.action;

import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.kernel.exception.AddressCityException;
import com.liferay.portal.kernel.exception.AddressStreetException;
import com.liferay.portal.kernel.exception.AddressZipException;
import com.liferay.portal.kernel.exception.DuplicateOrganizationException;
import com.liferay.portal.kernel.exception.EmailAddressException;
import com.liferay.portal.kernel.exception.NoSuchCountryException;
import com.liferay.portal.kernel.exception.NoSuchListTypeException;
import com.liferay.portal.kernel.exception.NoSuchOrganizationException;
import com.liferay.portal.kernel.exception.NoSuchRegionException;
import com.liferay.portal.kernel.exception.OrganizationNameException;
import com.liferay.portal.kernel.exception.OrganizationParentException;
import com.liferay.portal.kernel.exception.PhoneNumberException;
import com.liferay.portal.kernel.exception.PhoneNumberExtensionException;
import com.liferay.portal.kernel.exception.RequiredOrganizationException;
import com.liferay.portal.kernel.exception.WebsiteURLException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.sites.kernel.util.SitesUtil;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.io.InputStream;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_users_admin_web_portlet_MyOrganizationsPortlet", "javax.portlet.name=com_liferay_users_admin_web_portlet_UsersAdminPortlet", "mvc.command.name=/users_admin/edit_organization"}, service={MVCActionCommand.class})
public class EditOrganizationMVCActionCommand
extends BaseMVCActionCommand {
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private Http _http;
    private OrganizationService _organizationService;
    @Reference
    private Portal _portal;

    protected void deleteOrganizations(ActionRequest actionRequest) throws Exception {
        long[] deleteOrganizationIds;
        for (long deleteOrganizationId : deleteOrganizationIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteOrganizationIds"), (long)0L)) {
            this._organizationService.deleteOrganization(deleteOrganizationId);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            Organization organization = null;
            if (cmd.equals("add") || cmd.equals("update")) {
                organization = this.updateOrganization(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteOrganizations(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            if (organization != null) {
                redirect = this._http.setParameter(redirect, actionResponse.getNamespace() + "organizationId", organization.getOrganizationId());
            }
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e) {
            String mvcPath = "/edit_organization.jsp";
            if (e instanceof NoSuchOrganizationException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                mvcPath = "/error.jsp";
            } else if (e instanceof AssetCategoryException || e instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            } else if (e instanceof AddressCityException || e instanceof AddressStreetException || e instanceof AddressZipException || e instanceof DuplicateOrganizationException || e instanceof EmailAddressException || e instanceof NoSuchCountryException || e instanceof NoSuchListTypeException || e instanceof NoSuchRegionException || e instanceof OrganizationNameException || e instanceof OrganizationParentException || e instanceof PhoneNumberException || e instanceof PhoneNumberExtensionException || e instanceof RequiredOrganizationException || e instanceof WebsiteURLException) {
                if (e instanceof NoSuchListTypeException) {
                    NoSuchListTypeException nslte = (NoSuchListTypeException)e;
                    Class<?> clazz = e.getClass();
                    SessionErrors.add((PortletRequest)actionRequest, (String)(clazz.getName() + nslte.getType()));
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                }
                if (e instanceof RequiredOrganizationException) {
                    String redirect = this._portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                    long organizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"organizationId");
                    if (organizationId > 0L) {
                        redirect = this._http.setParameter(redirect, actionResponse.getNamespace() + "organizationId", organizationId);
                    }
                    if (Validator.isNotNull((String)redirect)) {
                        this.sendRedirect(actionRequest, actionResponse, redirect);
                        return;
                    }
                }
            } else {
                throw e;
            }
            actionResponse.setRenderParameter("mvcPath", mvcPath);
        }
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }

    @Reference(unbind="-")
    protected void setOrganizationService(OrganizationService organizationService) {
        this._organizationService = organizationService;
    }

    protected Organization updateOrganization(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long organizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"organizationId");
        long parentOrganizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentOrganizationSearchContainerPrimaryKeys", (long)0L);
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        long statusId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"statusId");
        String type = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        long regionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"regionId");
        long countryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"countryId");
        String comments = ParamUtil.getString((PortletRequest)actionRequest, (String)"comments");
        boolean deleteLogo = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"deleteLogo");
        byte[] logoBytes = null;
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        if (fileEntryId > 0L) {
            FileEntry fileEntry = this._dlAppLocalService.getFileEntry(fileEntryId);
            logoBytes = FileUtil.getBytes((InputStream)fileEntry.getContentStream());
        }
        boolean site = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"site");
        List addresses = UsersAdminUtil.getAddresses((ActionRequest)actionRequest);
        List emailAddresses = UsersAdminUtil.getEmailAddresses((ActionRequest)actionRequest);
        List orgLabors = UsersAdminUtil.getOrgLabors((ActionRequest)actionRequest);
        List phones = UsersAdminUtil.getPhones((ActionRequest)actionRequest);
        List websites = UsersAdminUtil.getWebsites((ActionRequest)actionRequest);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Organization.class.getName(), (PortletRequest)actionRequest);
        Organization organization = null;
        organization = organizationId <= 0L ? this._organizationService.addOrganization(parentOrganizationId, name, type, regionId, countryId, statusId, comments, site, addresses, emailAddresses, orgLabors, phones, websites, serviceContext) : this._organizationService.updateOrganization(organizationId, parentOrganizationId, name, type, regionId, countryId, statusId, comments, !deleteLogo, logoBytes, site, addresses, emailAddresses, orgLabors, phones, websites, serviceContext);
        long publicLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"publicLayoutSetPrototypeId");
        long privateLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"privateLayoutSetPrototypeId");
        boolean publicLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"publicLayoutSetPrototypeLinkEnabled", (publicLayoutSetPrototypeId > 0L ? 1 : 0) != 0);
        boolean privateLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayoutSetPrototypeLinkEnabled", (privateLayoutSetPrototypeId > 0L ? 1 : 0) != 0);
        Group organizationGroup = organization.getGroup();
        if (GroupPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Group)organizationGroup, (String)"UPDATE")) {
            SitesUtil.updateLayoutSetPrototypesLinks((Group)organizationGroup, (long)publicLayoutSetPrototypeId, (long)privateLayoutSetPrototypeId, (boolean)publicLayoutSetPrototypeLinkEnabled, (boolean)privateLayoutSetPrototypeLinkEnabled);
        }
        String reminderQueries = actionRequest.getParameter("reminderQueries");
        PortletPreferences portletPreferences = organization.getPreferences();
        LocalizationUtil.setLocalizedPreferencesValues((PortletRequest)actionRequest, (PortletPreferences)portletPreferences, (String)"reminderQueries");
        portletPreferences.setValue("reminderQueries", reminderQueries);
        portletPreferences.store();
        return organization;
    }
}

