/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.usersadmin.search.UserSearch;
import com.liferay.portlet.usersadmin.search.UserSearchTerms;
import com.liferay.users.admin.web.internal.search.AddUserOrganizationChecker;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class SelectOrganizationUsersManagementToolbarDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(SelectOrganizationUsersManagementToolbarDisplayContext.class);
    private final String _displayStyle;
    private String _orderByCol;
    private String _orderByType;
    private final Organization _organization;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final HttpServletRequest _request;
    private UserSearch _userSearch;

    public SelectOrganizationUsersManagementToolbarDisplayContext(HttpServletRequest request, RenderRequest renderRequest, RenderResponse renderResponse, Organization organization, String displayStyle) {
        this._request = request;
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._organization = organization;
        this._displayStyle = displayStyle;
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(SelectOrganizationUsersManagementToolbarDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)SelectOrganizationUsersManagementToolbarDisplayContext.this._request, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(SelectOrganizationUsersManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)SelectOrganizationUsersManagementToolbarDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public String getOrderByCol() {
        if (this._orderByCol == null) {
            this._orderByCol = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByCol", (String)"last-name");
        }
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType == null) {
            this._orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType", (String)"asc");
        }
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/select_organization_users.jsp");
        portletURL.setParameter("organizationId", String.valueOf(this._organization.getOrganizationId()));
        portletURL.setParameter("displayStyle", this._displayStyle);
        Object[] keywords = ParamUtil.getStringValues((HttpServletRequest)this._request, (String)"keywords");
        if (ArrayUtil.isNotEmpty((Object[])keywords)) {
            portletURL.setParameter("keywords", (String)keywords[keywords.length - 1]);
        }
        portletURL.setParameter("orderByCol", this.getOrderByCol());
        portletURL.setParameter("orderByType", this.getOrderByType());
        return portletURL;
    }

    public String getSearchActionURL() {
        PortletURL searchActionURL = this.getPortletURL();
        return searchActionURL.toString();
    }

    public SearchContainer getSearchContainer() {
        if (this._userSearch != null) {
            return this._userSearch;
        }
        UserSearch userSearch = new UserSearch((PortletRequest)this._renderRequest, this.getPortletURL());
        AddUserOrganizationChecker rowChecker = new AddUserOrganizationChecker(this._renderResponse, this._organization);
        userSearch.setRowChecker((RowChecker)rowChecker);
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        LinkedHashMap<String, List> userParams = new LinkedHashMap<String, List>();
        if (PropsValues.ORGANIZATIONS_ASSIGNMENT_STRICT && !permissionChecker.isCompanyAdmin() && !permissionChecker.hasPermission(themeDisplay.getScopeGroup(), User.class.getName(), User.class.getName(), "VIEW")) {
            User user = themeDisplay.getUser();
            try {
                userParams.put("usersOrgsTree", user.getOrganizations(true));
            }
            catch (PortalException pe) {
                _log.error((Object)pe, (Throwable)pe);
            }
        }
        UserSearchTerms searchTerms = (UserSearchTerms)userSearch.getSearchTerms();
        int total = UserLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), (int)searchTerms.getStatus(), userParams);
        userSearch.setTotal(total);
        List results = UserLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), (int)searchTerms.getStatus(), userParams, (int)userSearch.getStart(), (int)userSearch.getEnd(), (OrderByComparator)userSearch.getOrderByComparator());
        userSearch.setResults(results);
        this._userSearch = userSearch;
        return this._userSearch;
    }

    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public List<ViewTypeItem> getViewTypeItems() {
        return new ViewTypeItemList(this.getPortletURL(), this._displayStyle){
            {
                this.addCardViewTypeItem();
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref((Object)"");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)SelectOrganizationUsersManagementToolbarDisplayContext.this._request, (String)"all"));
                });
            }
        };
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(SelectOrganizationUsersManagementToolbarDisplayContext.this.getOrderByCol(), "first-name"));
                    dropdownItem.setHref(SelectOrganizationUsersManagementToolbarDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "first-name"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)SelectOrganizationUsersManagementToolbarDisplayContext.this._request, (String)"first-name"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(SelectOrganizationUsersManagementToolbarDisplayContext.this.getOrderByCol(), "last-name"));
                    dropdownItem.setHref(SelectOrganizationUsersManagementToolbarDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "last-name"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)SelectOrganizationUsersManagementToolbarDisplayContext.this._request, (String)"last-name"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(SelectOrganizationUsersManagementToolbarDisplayContext.this.getOrderByCol(), "screen-name"));
                    dropdownItem.setHref(SelectOrganizationUsersManagementToolbarDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "screen-name"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)SelectOrganizationUsersManagementToolbarDisplayContext.this._request, (String)"screen-name"));
                });
            }
        };
    }
}

