/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.test.util.search;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.test.randomizerbumpers.NumericStringRandomizerBumper;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.randomizerbumpers.UniqueStringRandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.users.admin.test.util.search.UserGroupBlueprint;
import com.liferay.users.admin.test.util.search.UserGroupBlueprintImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UserGroupSearchFixture {
    private final UserGroupLocalService _userGroupLocalService;
    private final List<UserGroup> _userGroups = new ArrayList<UserGroup>();

    public static UserGroupBlueprint.UserGroupBlueprintBuilder getTestUserGroupBlueprintBuilder() {
        final long companyId = UserGroupSearchFixture.getTestCompanyId();
        final long groupId = UserGroupSearchFixture.getTestGroupId();
        final long userId = UserGroupSearchFixture.getTestUserId();
        UserGroupBlueprintImpl.UserGroupBlueprintBuilderImpl userGroupBlueprintBuilder = new UserGroupBlueprintImpl.UserGroupBlueprintBuilderImpl();
        return userGroupBlueprintBuilder.companyId(companyId).description(RandomTestUtil.randomString((int)50, (RandomizerBumper[])new RandomizerBumper[0])).userId(userId).name(RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[]{NumericStringRandomizerBumper.INSTANCE, UniqueStringRandomizerBumper.INSTANCE})).serviceContext(new ServiceContext(){
            {
                this.setAddGroupPermissions(true);
                this.setAddGuestPermissions(true);
                this.setCompanyId(companyId);
                this.setScopeGroupId(groupId);
                this.setUserId(userId);
            }
        });
    }

    public UserGroupSearchFixture(UserGroupLocalService userGroupLocalService) {
        this._userGroupLocalService = userGroupLocalService;
    }

    public UserGroup addUserGroup(UserGroupBlueprint.UserGroupBlueprintBuilder userGroupBlueprintBuilder) {
        UserGroup userGroup = this._addUserGroup(userGroupBlueprintBuilder);
        this._userGroups.add(userGroup);
        return userGroup;
    }

    public List<UserGroup> getUserGroups() {
        return Collections.unmodifiableList(this._userGroups);
    }

    protected static long getTestCompanyId() {
        try {
            return TestPropsValues.getCompanyId();
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    protected static long getTestGroupId() {
        try {
            return TestPropsValues.getGroupId();
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    protected static long getTestUserId() {
        try {
            return TestPropsValues.getUserId();
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    private UserGroup _addUserGroup(UserGroupBlueprint.UserGroupBlueprintBuilder userGroupBlueprintBuilder) {
        UserGroupBlueprint userGroupBlueprint = userGroupBlueprintBuilder.build();
        try {
            return this._userGroupLocalService.addUserGroup(userGroupBlueprint.getUserId(), userGroupBlueprint.getCompanyId(), userGroupBlueprint.getName(), userGroupBlueprint.getDescription(), userGroupBlueprint.getServiceContext());
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }
}

