/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.test.util.search;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.test.util.UserTestUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.users.admin.test.util.search.DummyPermissionChecker;
import com.liferay.users.admin.test.util.search.GroupBlueprint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UserSearchFixture {
    private final List<AssetTag> _assetTags = new ArrayList<AssetTag>();
    private long _companyId;
    private final List<Group> _groups = new ArrayList<Group>();
    private PermissionChecker _permissionChecker;
    private String _principal;
    private final List<User> _users = new ArrayList<User>();

    public Group addGroup() throws Exception {
        Group group = GroupTestUtil.addGroup();
        this._groups.add(group);
        return group;
    }

    public Group addGroup(GroupBlueprint groupBlueprint) throws Exception {
        Group group = this.addGroup();
        Locale locale = groupBlueprint.getDefaultLocale();
        if (locale != null) {
            GroupTestUtil.updateDisplaySettings((long)group.getGroupId(), null, (Locale)locale);
        }
        return group;
    }

    public User addUser(String screenName, Group group, String ... assetTagNames) throws Exception {
        ServiceContext serviceContext = UserSearchFixture.getServiceContext(group);
        serviceContext.setAssetTagNames(assetTagNames);
        User user = this._addUser(screenName, new long[]{group.getGroupId()}, serviceContext);
        this._users.add(user);
        List assetTags = AssetTagLocalServiceUtil.getTags((String)user.getModelClassName(), (long)user.getPrimaryKey());
        this._assetTags.addAll(assetTags);
        return user;
    }

    public List<AssetTag> getAssetTags() {
        return this._assetTags;
    }

    public List<Group> getGroups() {
        return this._groups;
    }

    public SearchContext getSearchContext(String keywords) throws Exception {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(TestPropsValues.getCompanyId());
        searchContext.setKeywords(keywords);
        searchContext.setUserId(TestPropsValues.getUserId());
        return searchContext;
    }

    public List<User> getUsers() {
        return this._users;
    }

    public void setUp() throws Exception {
        this._companyId = TestPropsValues.getCompanyId();
        this._permissionChecker = PermissionThreadLocal.getPermissionChecker();
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)new DummyPermissionChecker(){

            @Override
            public long getCompanyId() {
                return UserSearchFixture.this._companyId;
            }

            @Override
            public boolean hasPermission(Group group, String name, long primKey, String actionId) {
                return true;
            }

            @Override
            public boolean hasPermission(Group group, String name, String primKey, String actionId) {
                return true;
            }

            @Override
            public boolean hasPermission(long groupId, String name, long primKey, String actionId) {
                return true;
            }

            @Override
            public boolean hasPermission(long groupId, String name, String primKey, String actionId) {
                return true;
            }

            @Override
            public boolean isCompanyAdmin(long companyId) {
                return true;
            }
        });
        this._principal = PrincipalThreadLocal.getName();
        PrincipalThreadLocal.setName((long)TestPropsValues.getUserId());
    }

    public void tearDown() {
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._permissionChecker);
        PrincipalThreadLocal.setName((String)this._principal);
    }

    public Map<String, String> toMap(List<Document> list) {
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        for (Document document : list) {
            Object[] values = document.getValues("assetTagNames");
            Arrays.sort(values);
            map.put(document.get("screenName"), StringUtil.merge((Object[])values));
        }
        return map;
    }

    public Map<String, String> toMap(User user, String ... tags) {
        return Collections.singletonMap(user.getScreenName(), this.toStringTags(tags));
    }

    public String toStringTags(String[] tags) {
        ArrayList<String> list = new ArrayList<String>(tags.length);
        for (String tag : tags) {
            list.add(StringUtil.toLowerCase((String)tag));
        }
        Collections.sort(list);
        return StringUtil.merge(list);
    }

    protected static ServiceContext getServiceContext(Group group) throws Exception {
        return ServiceContextTestUtil.getServiceContext((long)group.getGroupId(), (long)TestPropsValues.getUserId());
    }

    private User _addUser(String screenName, long[] groupIds, ServiceContext serviceContext) throws Exception {
        return UserTestUtil.addUser((long)this._companyId, (long)TestPropsValues.getUserId(), (String)screenName, (Locale)LocaleUtil.getDefault(), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (long[])groupIds, (ServiceContext)serviceContext);
    }
}

