/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.demo.data.creator.internal;

import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.users.admin.demo.data.creator.UserDemoDataCreator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseUserDemoDataCreator
implements UserDemoDataCreator {
    protected UserLocalService userLocalService;
    private static final String _RANDOM_USER_API = "https://randomuser.me/api?inc=email,gender,dob,picture&noinfo";
    private static final Log _log = LogFactoryUtil.getLog(BaseUserDemoDataCreator.class);
    private static final List<String> _jobTitles = BaseUserDemoDataCreator._read("job_titles");
    private final List<Long> _userIds = new CopyOnWriteArrayList<Long>();

    public User createUser(long companyId, String emailAddress) throws PortalException {
        return this.createUser(companyId, "", emailAddress, "", "");
    }

    public User createUser(long companyId, String screenName, String emailAddress, String firstName, String lastName) throws PortalException {
        User user;
        byte[] portraitBytes;
        Date birthDate;
        boolean male;
        block17: {
            male = true;
            birthDate = new Date();
            portraitBytes = null;
            try {
                URL url = new URL(_RANDOM_USER_API);
                try (InputStream inputStream = url.openStream();){
                    String json = StringUtil.read((InputStream)inputStream);
                    JSONObject rootJSONObject = JSONFactoryUtil.createJSONObject((String)json);
                    JSONArray jsonArray = rootJSONObject.getJSONArray("results");
                    JSONObject userJSONObject = jsonArray.getJSONObject(0);
                    emailAddress = this._getEmailAddress(emailAddress, userJSONObject);
                    male = StringUtil.equalsIgnoreCase((String)userJSONObject.getString("gender"), (String)"male");
                    birthDate = this._getBirthDate(birthDate, userJSONObject);
                    JSONObject pictureJSONObject = userJSONObject.getJSONObject("picture");
                    String portraitURL = pictureJSONObject.getString("large");
                    portraitBytes = this._getBytes(new URL(portraitURL));
                }
            }
            catch (IOException ioException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)ioException);
                }
                if (!Validator.isNull((String)emailAddress)) break block17;
                String randomString = StringUtil.randomString();
                emailAddress = randomString.concat("@liferay.com");
            }
        }
        if ((user = this.userLocalService.fetchUserByEmailAddress(companyId, emailAddress)) != null) {
            return user;
        }
        user = this._createBasicUser(companyId, screenName, emailAddress, firstName, lastName, male, birthDate);
        this._userIds.add(user.getUserId());
        if (portraitBytes != null) {
            this.userLocalService.updatePortrait(user.getUserId(), portraitBytes);
        }
        return user;
    }

    public void delete() throws PortalException {
        block3: {
            try {
                for (long userId : this._userIds) {
                    this._userIds.remove(userId);
                    this.userLocalService.deleteUser(userId);
                }
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)noSuchUserException);
            }
        }
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this.userLocalService = userLocalService;
    }

    private static List<String> _read(String fileName) {
        return Arrays.asList(StringUtil.split((String)StringUtil.read(BaseUserDemoDataCreator.class, (String)("dependencies/" + fileName + ".txt")), (char)'\n'));
    }

    private User _createBasicUser(long companyId, String screenName, String emailAddress, String firstName, String lastName, boolean male, Date birthDate) throws PortalException {
        String[] fullNameArray = this._getFullNameArray(emailAddress);
        if (Validator.isNull((String)firstName)) {
            firstName = fullNameArray[0];
        }
        if (Validator.isNull((String)lastName)) {
            lastName = fullNameArray[1];
        }
        boolean autoPassword = false;
        String password1 = "test";
        String password2 = "test";
        boolean autoScreenName = Validator.isNull((String)screenName);
        Locale locale = LocaleUtil.getDefault();
        String middleName = "";
        long prefixListTypeId = 0L;
        long suffixListTypeId = 0L;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(birthDate);
        int birthdayMonth = calendar.get(2);
        int birthdayDay = calendar.get(5);
        int birthdayYear = calendar.get(1);
        String jobTitle = this._getRandomElement(_jobTitles);
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendMail = false;
        return this.userLocalService.addUser(0L, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, locale, firstName, middleName, lastName, prefixListTypeId, suffixListTypeId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendMail, new ServiceContext());
    }

    private Date _getBirthDate(Date birthDate, JSONObject userJSONObject) {
        block2: {
            String dob = userJSONObject.getString("dob");
            try {
                DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd HH:mm:ss");
                birthDate = dateFormat.parse(dob);
            }
            catch (ParseException parseException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)parseException);
            }
        }
        return birthDate;
    }

    private byte[] _getBytes(URL url) throws IOException {
        try (InputStream inputStream = url.openStream();){
            byte[] byArray = FileUtil.getBytes((InputStream)inputStream);
            return byArray;
        }
    }

    private String _getEmailAddress(String emailAddress, JSONObject userJSONObject) {
        if (Validator.isNull((String)emailAddress)) {
            emailAddress = userJSONObject.getString("email");
        }
        if (!Validator.isEmailAddress((String)emailAddress)) {
            String[] emailAddressParts = StringUtil.split((String)emailAddress, (char)'@');
            String normalizedEmailAddress = FriendlyURLNormalizerUtil.normalize((String)emailAddressParts[0]);
            if (StringUtil.endsWith((String)normalizedEmailAddress, (char)'-')) {
                normalizedEmailAddress = StringUtil.randomString();
            }
            emailAddress = String.format("%s@%s", normalizedEmailAddress, emailAddressParts[1]);
        }
        return emailAddress;
    }

    private String[] _getFullNameArray(String emailAddress) {
        String emailAccountName = emailAddress.substring(0, emailAddress.indexOf("@"));
        String[] fullNameArray = StringUtil.split((String)emailAccountName, (String)".");
        String firstName = StringUtil.randomString();
        String lastName = StringUtil.randomString();
        if (fullNameArray.length > 0) {
            firstName = StringUtil.upperCaseFirstLetter((String)fullNameArray[0]);
        }
        if (fullNameArray.length > 1) {
            lastName = StringUtil.upperCaseFirstLetter((String)fullNameArray[1]);
        }
        return new String[]{firstName, lastName};
    }

    private String _getRandomElement(List<String> list) {
        return list.get(RandomUtil.nextInt((int)list.size()));
    }
}

