/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.groups.admin.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.usergroupsadmin.search.UserGroupChecker;
import com.liferay.portlet.usergroupsadmin.search.UserGroupDisplayTerms;
import com.liferay.portlet.usergroupsadmin.search.UserGroupSearch;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class ViewUserGroupsManagementToolbarDisplayContext {
    private final String _displayStyle;
    private final HttpServletRequest _httpServletRequest;
    private String _keywords;
    private String _orderByCol;
    private String _orderByType;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private UserGroupSearch _userGroupSearch;

    public ViewUserGroupsManagementToolbarDisplayContext(HttpServletRequest httpServletRequest, RenderRequest renderRequest, RenderResponse renderResponse, String displayStyle) {
        this._httpServletRequest = httpServletRequest;
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._displayStyle = displayStyle;
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                if (ViewUserGroupsManagementToolbarDisplayContext.this._hasAddUserGroupPermission()) {
                    this.add(dropdownItem -> {
                        dropdownItem.setHref((Object)StringBundler.concat((String[])new String[]{"javascript:", ViewUserGroupsManagementToolbarDisplayContext.this._renderResponse.getNamespace(), "deleteUserGroups()"}));
                        dropdownItem.setIcon("trash");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewUserGroupsManagementToolbarDisplayContext.this._httpServletRequest, (String)"delete"));
                        dropdownItem.setQuickAction(true);
                    });
                }
            }
        };
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public CreationMenu getCreationMenu() throws PortalException {
        return new CreationMenu(){
            {
                this.addDropdownItem(dropdownItem -> {
                    dropdownItem.setHref(ViewUserGroupsManagementToolbarDisplayContext.this._renderResponse.createRenderURL(), new Object[]{"mvcPath", "/edit_user_group.jsp", "redirect", ViewUserGroupsManagementToolbarDisplayContext.this._renderResponse.createRenderURL()});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewUserGroupsManagementToolbarDisplayContext.this._httpServletRequest, (String)"add"));
                });
            }
        };
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(ViewUserGroupsManagementToolbarDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewUserGroupsManagementToolbarDisplayContext.this._httpServletRequest, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(ViewUserGroupsManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewUserGroupsManagementToolbarDisplayContext.this._httpServletRequest, (String)"order-by"));
                });
            }
        };
    }

    public String getKeywords() {
        if (Validator.isNull((String)this._keywords)) {
            this._keywords = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords");
        }
        return this._keywords;
    }

    public String getOrderByCol() {
        if (Validator.isNull((String)this._orderByCol)) {
            this._orderByCol = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByCol", (String)"name");
        }
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (Validator.isNull((String)this._orderByType)) {
            this._orderByType = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByType", (String)"asc");
        }
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view.jsp");
        String viewUserGroupsRedirect = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"viewUserGroupsRedirect");
        if (Validator.isNotNull((String)viewUserGroupsRedirect)) {
            portletURL.setParameter("viewUserGroupsRedirect", viewUserGroupsRedirect);
        }
        portletURL.setParameter("displayStyle", this._displayStyle);
        if (Validator.isNotNull((String)this.getKeywords())) {
            portletURL.setParameter("keywords", this.getKeywords());
        }
        portletURL.setParameter("orderByCol", this.getOrderByCol());
        portletURL.setParameter("orderByType", this.getOrderByType());
        if (this._userGroupSearch != null) {
            portletURL.setParameter(this._userGroupSearch.getCurParam(), String.valueOf(this._userGroupSearch.getCur()));
            portletURL.setParameter(this._userGroupSearch.getDeltaParam(), String.valueOf(this._userGroupSearch.getDelta()));
        }
        return portletURL;
    }

    public String getSearchActionURL() {
        PortletURL searchActionURL = this.getPortletURL();
        return searchActionURL.toString();
    }

    public SearchContainer getSearchContainer() throws Exception {
        if (this._userGroupSearch != null) {
            return this._userGroupSearch;
        }
        UserGroupSearch userGroupSearch = new UserGroupSearch((PortletRequest)this._renderRequest, this.getPortletURL());
        userGroupSearch.setRowChecker((RowChecker)new UserGroupChecker(this._renderResponse));
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        UserGroupDisplayTerms userGroupSearchTerms = (UserGroupDisplayTerms)userGroupSearch.getSearchTerms();
        LinkedHashMap<String, String> userGroupParams = new LinkedHashMap<String, String>();
        String keywords = userGroupSearchTerms.getKeywords();
        if (Validator.isNotNull((String)keywords)) {
            userGroupParams.put("expandoAttributes", keywords);
        }
        List results = UserGroupLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (String)keywords, userGroupParams, (int)userGroupSearch.getStart(), (int)userGroupSearch.getEnd(), (OrderByComparator)userGroupSearch.getOrderByComparator());
        int total = UserGroupLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (String)keywords, userGroupParams);
        userGroupSearch.setResults(results);
        userGroupSearch.setTotal(total);
        this._userGroupSearch = userGroupSearch;
        return this._userGroupSearch;
    }

    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public List<ViewTypeItem> getViewTypeItems() {
        return new ViewTypeItemList(this.getPortletURL(), this._displayStyle){
            {
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    public boolean showCreationMenu() throws PortalException {
        return this._hasAddUserGroupPermission();
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref((Object)"");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewUserGroupsManagementToolbarDisplayContext.this._httpServletRequest, (String)"all"));
                });
            }
        };
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(ViewUserGroupsManagementToolbarDisplayContext.this.getOrderByCol(), "name"));
                    dropdownItem.setHref(ViewUserGroupsManagementToolbarDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "name"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ViewUserGroupsManagementToolbarDisplayContext.this._httpServletRequest, (String)"name"));
                });
            }
        };
    }

    private boolean _hasAddUserGroupPermission() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return PortalPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (String)"ADD_USER_GROUP");
    }
}

