/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.groups.admin.web.internal.search;

import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.permission.UserGroupPermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_user_groups_admin_web_portlet_UserGroupsAdminPortlet"}, service={Indexer.class})
public class UserGroupIndexer
extends BaseIndexer<UserGroup> {
    public static final String CLASS_NAME = UserGroup.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(UserGroupIndexer.class);
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    @Reference
    private UserGroupPermission _userGroupPermission;

    public UserGroupIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "uid", "userGroupId"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
        this.setStagingAware(false);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        UserGroup userGroup = this._userGroupLocalService.getUserGroup(entryClassPK);
        return this._userGroupPermission.contains(permissionChecker, userGroup.getUserGroupId(), actionId);
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "description", false);
        this.addSearchTerm(searchQuery, searchContext, "name", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(UserGroup userGroup) throws Exception {
        this.deleteDocument(userGroup.getCompanyId(), userGroup.getUserGroupId());
    }

    protected Document doGetDocument(UserGroup userGroup) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)userGroup);
        document.addKeyword("companyId", userGroup.getCompanyId());
        document.addText("description", userGroup.getDescription());
        document.addText("name", userGroup.getName());
        document.addKeyword("userGroupId", userGroup.getUserGroupId());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        String title = document.get("name");
        String content = null;
        return new Summary(title, content);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        UserGroup userGroup = this._userGroupLocalService.getUserGroup(classPK);
        this.doReindex(userGroup);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexUserGroups(companyId);
    }

    protected void doReindex(UserGroup userGroup) throws Exception {
        Document document = this.getDocument(userGroup);
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), userGroup.getCompanyId(), document, this.isCommitImmediately());
    }

    protected void reindexUserGroups(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._userGroupLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(userGroup -> {
            block2: {
                try {
                    Document document = this.getDocument(userGroup);
                    indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index user group " + userGroup.getUserGroupId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

