/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.user.groups.admin.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import com.liferay.user.groups.admin.uad.constants.UserGroupsAdminUADConstants;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the user group UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link UserGroupUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseUserGroupUADAnonymizer
	extends DynamicQueryUADAnonymizer<UserGroup> {

	@Override
	public void autoAnonymize(
			UserGroup userGroup, long userId, User anonymousUser)
		throws PortalException {

		if (userGroup.getUserId() == userId) {
			userGroup.setUserId(anonymousUser.getUserId());
			userGroup.setUserName(anonymousUser.getFullName());

			autoAnonymizeAssetEntry(userGroup, anonymousUser);
		}

		userGroupLocalService.updateUserGroup(userGroup);
	}

	@Override
	public void delete(UserGroup userGroup) throws PortalException {
		userGroupLocalService.deleteUserGroup(userGroup);
	}

	@Override
	public Class<UserGroup> getTypeClass() {
		return UserGroup.class;
	}

	protected void autoAnonymizeAssetEntry(
		UserGroup userGroup, User anonymousUser) {

		AssetEntry assetEntry = fetchAssetEntry(userGroup);

		if (assetEntry != null) {
			assetEntry.setUserId(anonymousUser.getUserId());
			assetEntry.setUserName(anonymousUser.getFullName());

			assetEntryLocalService.updateAssetEntry(assetEntry);
		}
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return userGroupLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return UserGroupsAdminUADConstants.USER_ID_FIELD_NAMES_USER_GROUP;
	}

	protected AssetEntry fetchAssetEntry(UserGroup userGroup) {
		return assetEntryLocalService.fetchEntry(
			UserGroup.class.getName(), userGroup.getUserGroupId());
	}

	@Reference
	protected AssetEntryLocalService assetEntryLocalService;

	@Reference
	protected UserGroupLocalService userGroupLocalService;

}