/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.groups.admin.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import com.liferay.user.groups.admin.uad.constants.UserGroupsAdminUADConstants;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseUserGroupUADAnonymizer
extends DynamicQueryUADAnonymizer<UserGroup> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected UserGroupLocalService userGroupLocalService;

    public void autoAnonymize(UserGroup userGroup, long userId, User anonymousUser) throws PortalException {
        if (userGroup.getUserId() == userId) {
            userGroup.setUserId(anonymousUser.getUserId());
            userGroup.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(userGroup, anonymousUser);
        }
        this.userGroupLocalService.updateUserGroup(userGroup);
    }

    public void delete(UserGroup userGroup) throws PortalException {
        this.userGroupLocalService.deleteUserGroup(userGroup);
    }

    public Class<UserGroup> getTypeClass() {
        return UserGroup.class;
    }

    protected void autoAnonymizeAssetEntry(UserGroup userGroup, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(userGroup);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.userGroupLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return UserGroupsAdminUADConstants.USER_ID_FIELD_NAMES_USER_GROUP;
    }

    protected AssetEntry fetchAssetEntry(UserGroup userGroup) {
        return this.assetEntryLocalService.fetchEntry(UserGroup.class.getName(), userGroup.getUserGroupId());
    }
}

