/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.groups.admin.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class UserGroupStagedModelDataHandler
extends BaseStagedModelDataHandler<UserGroup> {
    public static final String[] CLASS_NAMES = new String[]{UserGroup.class.getName()};
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private UserGroupLocalService _userGroupLocalService;

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        UserGroup userGroup = (UserGroup)this.fetchStagedModelByUuidAndGroupId(uuid, group.getCompanyId());
        if (userGroup != null) {
            this.deleteStagedModel(userGroup);
        }
    }

    public void deleteStagedModel(UserGroup userGroup) throws PortalException {
        this._userGroupLocalService.deleteUserGroup(userGroup);
    }

    public List<UserGroup> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return ListUtil.fromArray((Object[])new UserGroup[]{this._userGroupLocalService.fetchUserGroupByUuidAndCompanyId(uuid, companyId)});
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(UserGroup userGroup) {
        return userGroup.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, UserGroup userGroup) throws Exception {
        Element userGroupElement = portletDataContext.getExportDataElement((ClassedModel)userGroup);
        portletDataContext.addClassedModel(userGroupElement, ExportImportPathUtil.getModelPath((StagedModel)userGroup), (ClassedModel)userGroup);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long userGroupId) throws Exception {
        UserGroup existingUserGroup = (UserGroup)this.fetchMissingReference(uuid, groupId);
        if (existingUserGroup == null) {
            return;
        }
        Map userGroupIds = portletDataContext.getNewPrimaryKeysMap(UserGroup.class);
        userGroupIds.put(userGroupId, existingUserGroup.getUserGroupId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, UserGroup userGroup) throws Exception {
        long userId = portletDataContext.getUserId(userGroup.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)userGroup);
        UserGroup existingUserGroup = (UserGroup)this.fetchStagedModelByUuidAndGroupId(userGroup.getUuid(), portletDataContext.getGroupId());
        if (existingUserGroup == null) {
            existingUserGroup = this._userGroupLocalService.fetchUserGroup(portletDataContext.getCompanyId(), userGroup.getName());
        }
        UserGroup importedUserGroup = null;
        if (existingUserGroup == null) {
            serviceContext.setUuid(userGroup.getUuid());
            importedUserGroup = this._userGroupLocalService.addUserGroup(userId, portletDataContext.getCompanyId(), userGroup.getName(), userGroup.getDescription(), serviceContext);
        } else {
            importedUserGroup = this._userGroupLocalService.updateUserGroup(portletDataContext.getCompanyId(), existingUserGroup.getUserGroupId(), userGroup.getName(), userGroup.getDescription(), serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)userGroup, (ClassedModel)importedUserGroup);
    }
}

