/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.user.associated.data.anonymizer.UADAnonymizer;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.web.internal.portlet.action.BaseUADMVCActionCommand;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_user_associated_data_web_portlet_UserAssociatedData", "mvc.command.name=/delete_uad_applications"}, service={MVCActionCommand.class})
public class DeleteUADApplicationsMVCActionCommand
extends BaseUADMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(DeleteUADApplicationsMVCActionCommand.class);

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] groupIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"groupIds");
        long selectedUserId = this.getSelectedUserId(actionRequest);
        for (String applicationKey : this.getApplicationKeys(actionRequest)) {
            for (UADDisplay uadDisplay : this.uadRegistry.getApplicationUADDisplays(applicationKey)) {
                Class typeClass = uadDisplay.getTypeClass();
                UADAnonymizer uadAnonymizer = this.uadRegistry.getUADAnonymizer(typeClass.getName());
                List entities = uadDisplay.search(selectedUserId, groupIds, null, null, null, -1, -1);
                for (Object entity : entities) {
                    try {
                        uadAnonymizer.delete(entity);
                    }
                    catch (NoSuchModelException nsme) {
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug((Object)nsme, (Throwable)nsme);
                    }
                }
            }
        }
        this.doReviewableRedirect(actionRequest, actionResponse);
    }
}

