/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.display;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.web.internal.display.UADEntity;
import com.liferay.user.associated.data.web.internal.util.SafeDisplayValueUtil;
import com.liferay.user.associated.data.web.internal.util.UADLanguageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UADInfoPanelDisplay {
    private boolean _hierarchyView;
    private boolean _topLevelView = true;
    private UADDisplay _uadDisplay;
    private final List<UADEntity> _uadEntities = new ArrayList<UADEntity>();

    public void addUADEntities(List<UADEntity> uadEntities) {
        this._uadEntities.addAll(uadEntities);
    }

    public UADEntity getFirstUADEntity() {
        if (this._uadEntities.size() > 0) {
            return this._uadEntities.get(0);
        }
        return null;
    }

    public String getSubtitle(Locale locale) {
        if (this._uadEntities.size() == 0) {
            if (this._uadDisplay != null) {
                return UADLanguageUtil.getApplicationName(this._uadDisplay, locale);
            }
            return null;
        }
        if (this._uadEntities.size() == 1) {
            return this._uadDisplay.getTypeName(locale);
        }
        return LanguageUtil.format((Locale)locale, (String)"x-items-are-selected", (Object)this.getUADEntitiesCount());
    }

    public String getTitle(Locale locale) {
        if (this._uadEntities.size() == 0) {
            if (!this._hierarchyView || !this._topLevelView) {
                return this._uadDisplay.getTypeName(locale);
            }
            return null;
        }
        if (this._uadEntities.size() == 1) {
            UADEntity uadEntity = this.getFirstUADEntity();
            Map displayValues = this._uadDisplay.getFieldValues(uadEntity.getEntity(), this._uadDisplay.getDisplayFieldNames(), locale);
            return SafeDisplayValueUtil.get(displayValues.get(this._uadDisplay.getDisplayFieldNames()[0]));
        }
        if (!this._hierarchyView) {
            return this._uadDisplay.getTypeName(locale);
        }
        return null;
    }

    public UADDisplay getUADDisplay() {
        return this._uadDisplay;
    }

    public int getUADEntitiesCount() {
        return this._uadEntities.size();
    }

    public void setHierarchyView(boolean hierarchyView) {
        this._hierarchyView = hierarchyView;
    }

    public void setTopLevelView(boolean topLevelView) {
        this._topLevelView = topLevelView;
    }

    public void setUADDisplay(UADDisplay uadDisplay) {
        this._uadDisplay = uadDisplay;
    }
}

