/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.display;

import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.user.associated.data.component.UADComponent;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.display.UADHierarchyDeclaration;
import com.liferay.user.associated.data.web.internal.display.ContainerDisplay;
import com.liferay.user.associated.data.web.internal.util.UADLanguageUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class UADHierarchyDisplay {
    private final Class<?>[] _containerTypeClasses;
    private final UADDisplay<?>[] _containerUADDisplays;
    private final Class<?>[] _typeClasses;
    private final Map<Class<?>, UADDisplay<?>> _uadDisplayMap;
    private final UADDisplay<?>[] _uadDisplays;
    private final UADHierarchyDeclaration _uadHierarchyDeclaration;

    public UADHierarchyDisplay(UADHierarchyDeclaration uadHierarchyDeclaration) {
        this._uadHierarchyDeclaration = uadHierarchyDeclaration;
        this._containerUADDisplays = this._uadHierarchyDeclaration.getContainerUADDisplays();
        Stream<UADDisplay<?>> containerUADDisplayStream = Arrays.stream(this._containerUADDisplays);
        this._containerTypeClasses = (Class[])containerUADDisplayStream.map(UADComponent::getTypeClass).toArray(Class[]::new);
        this._uadDisplays = (UADDisplay[])ArrayUtil.append((Object[])this._containerUADDisplays, (Object[])this._uadHierarchyDeclaration.getNoncontainerUADDisplays());
        LinkedHashMap uadDisplayMap = new LinkedHashMap();
        for (UADDisplay<?> uadDisplay : this._uadDisplays) {
            uadDisplayMap.put(uadDisplay.getTypeClass(), uadDisplay);
        }
        this._uadDisplayMap = uadDisplayMap;
        Stream<UADDisplay<?>> stream = Arrays.stream(this._uadDisplays);
        this._typeClasses = (Class[])stream.map(UADComponent::getTypeClass).toArray(Class[]::new);
    }

    public <T> void addPortletBreadcrumbEntries(HttpServletRequest httpServletRequest, RenderResponse renderResponse, Locale locale) throws Exception {
        PortletURL baseURL = renderResponse.createRenderURL();
        String applicationKey = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"applicationKey");
        String puid = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_u_i_d");
        String scope = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"scope");
        baseURL.setParameter("applicationKey", applicationKey);
        baseURL.setParameter("p_u_i_d", puid);
        baseURL.setParameter("scope", scope);
        PortletURL applicationURL = PortletURLUtil.clone((PortletURL)baseURL, (MimeResponse)renderResponse);
        applicationURL.setParameter("mvcRenderCommandName", "/review_uad_data");
        String className = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"parentContainerClass");
        UADDisplay<?> uadDisplay = this._getUADDisplayByTypeClassName(className);
        String applicationName = UADLanguageUtil.getApplicationName(uadDisplay, locale);
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)httpServletRequest, (String)applicationName, (String)applicationURL.toString());
        ArrayList<KeyValuePair> parentBreadcrumbs = new ArrayList<KeyValuePair>();
        String primaryKey = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"parentContainerId");
        Object container = uadDisplay.get((Serializable)((Object)primaryKey));
        Class parentContainerClass = uadDisplay.getParentContainerClass();
        String parentContainerId = String.valueOf(uadDisplay.getParentContainerId(container));
        while (!parentContainerId.equals("0") && !parentContainerId.equals("-1")) {
            PortletURL portletURL = PortletURLUtil.clone((PortletURL)baseURL, (MimeResponse)renderResponse);
            portletURL.setParameter("mvcRenderCommandName", "/view_uad_hierarchy");
            UADDisplay<?> parentContainerUADDisplay = this._getUADDisplayByTypeClass(parentContainerClass);
            String parentContainerName = parentContainerUADDisplay.getName(parentContainerUADDisplay.get((Serializable)((Object)parentContainerId)), locale);
            portletURL.setParameter("parentContainerClass", parentContainerClass.getName());
            portletURL.setParameter("parentContainerId", parentContainerId);
            parentBreadcrumbs.add(new KeyValuePair(parentContainerName, portletURL.toString()));
            parentContainerClass = parentContainerUADDisplay.getParentContainerClass();
            parentContainerId = String.valueOf(parentContainerUADDisplay.getParentContainerId(parentContainerUADDisplay.get((Serializable)((Object)parentContainerId))));
        }
        Collections.reverse(parentBreadcrumbs);
        for (KeyValuePair keyValuePair : parentBreadcrumbs) {
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)httpServletRequest, (String)keyValuePair.getKey(), (String)keyValuePair.getValue());
        }
        String name = uadDisplay.getName(container, locale);
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)httpServletRequest, (String)name, null);
    }

    public long countAll(long userId) {
        long count = 0L;
        for (UADDisplay<?> uadDisplay : this._uadDisplays) {
            count += uadDisplay.count(userId);
        }
        return count;
    }

    public String[] getColumnFieldNames() {
        return (String[])ArrayUtil.append((Object[])new String[]{"name", "count"}, (Object[])this._uadHierarchyDeclaration.getExtraColumnNames());
    }

    public Map<Class<?>, List<Serializable>> getContainerItemPKsMap(Class<?> parentContainerClass, Serializable parentContainerId, long userId) {
        LinkedHashMap containerItemPKsMap = new LinkedHashMap();
        if (ArrayUtil.contains((Object[])this._containerTypeClasses, parentContainerClass)) {
            for (UADDisplay<?> containerItemUADDisplay : this._uadDisplays) {
                Class containerItemTypeClass = containerItemUADDisplay.getTypeClass();
                List<Serializable> containerItemPKs = this._getContainerItemPKs(parentContainerClass, parentContainerId, containerItemTypeClass, userId);
                this._addEntities(containerItemPKsMap, containerItemPKs, containerItemTypeClass);
            }
        }
        return containerItemPKsMap;
    }

    public <T> String getEditURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, T object) throws Exception {
        T unwrappedObject = this.unwrap(object);
        UADDisplay<?> uadDisplay = this._getUADDisplayByObject(unwrappedObject);
        return uadDisplay.getEditURL(unwrappedObject, liferayPortletRequest, liferayPortletResponse);
    }

    public String getEntitiesTypeLabel(Locale locale) {
        return this._uadHierarchyDeclaration.getEntitiesTypeLabel(locale);
    }

    public <T> Map<String, Object> getFieldValues(T object, Locale locale) {
        LinkedHashMap<String, Object> fieldValues = new LinkedHashMap<String, Object>();
        UADDisplay<?> uadDisplay = this._getUADDisplayByObject(this.unwrap(object));
        if (uadDisplay != null) {
            if (object instanceof ContainerDisplay) {
                ContainerDisplay containerDisplay = (ContainerDisplay)object;
                Object containerObject = containerDisplay.getContainer();
                fieldValues.put("name", uadDisplay.getName(containerObject, locale));
                fieldValues.put("count", containerDisplay.getCount());
                fieldValues.putAll(uadDisplay.getFieldValues(containerObject, this._uadHierarchyDeclaration.getExtraColumnNames(), locale));
            } else {
                fieldValues.put("name", uadDisplay.getName(object, locale));
                fieldValues.put("count", "--");
                fieldValues.putAll(uadDisplay.getFieldValues(object, this._uadHierarchyDeclaration.getExtraColumnNames(), locale));
            }
        }
        return fieldValues;
    }

    public Class<?> getFirstContainerTypeClass() {
        return this._containerTypeClasses[0];
    }

    public <T> Serializable getPrimaryKey(T object) {
        T unwrappedObject = this.unwrap(object);
        UADDisplay<?> uadDisplay = this._getUADDisplayByObject(unwrappedObject);
        return uadDisplay.getPrimaryKey(unwrappedObject);
    }

    public String[] getSortingFieldNames() {
        return this.getColumnFieldNames();
    }

    public <T> Class<?> getTypeClass(T object) {
        UADDisplay<?> uadDisplay = this._getUADDisplayByObject(this.unwrap(object));
        return uadDisplay.getTypeClass();
    }

    public Class<?>[] getTypeClasses() {
        return this._typeClasses;
    }

    public UADDisplay<?>[] getUADDisplays() {
        return this._uadDisplays;
    }

    public <T> String getViewURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String applicationKey, T object, long selectedUserId) throws Exception {
        T unwrappedObject = this.unwrap(object);
        UADDisplay<?> uadDisplay = this._getUADDisplayByObject(unwrappedObject);
        Class typeClass = uadDisplay.getTypeClass();
        if (!ArrayUtil.contains((Object[])this._containerTypeClasses, (Object)typeClass)) {
            return null;
        }
        PortletURL renderURL = liferayPortletResponse.createRenderURL();
        renderURL.setParameter("mvcRenderCommandName", "/view_uad_hierarchy");
        renderURL.setParameter("applicationKey", applicationKey);
        renderURL.setParameter("parentContainerClass", typeClass.getName());
        renderURL.setParameter("parentContainerId", String.valueOf(uadDisplay.getPrimaryKey(unwrappedObject)));
        renderURL.setParameter("p_u_i_d", String.valueOf(selectedUserId));
        String scope = ParamUtil.getString((PortletRequest)liferayPortletRequest, (String)"scope");
        renderURL.setParameter("scope", scope);
        return renderURL.toString();
    }

    public <T> boolean isUserOwned(T object, long userId) {
        T unwrappedObject = this.unwrap(object);
        UADDisplay<?> uadDisplay = this._getUADDisplayByObject(unwrappedObject);
        return uadDisplay.isUserOwned(unwrappedObject, userId);
    }

    public List<Object> search(Class<?> parentContainerClass, Serializable parentContainerId, long userId, long[] groupIds, String keywords, String orderByField, String orderByType, int start, int end) throws Exception {
        Objects.requireNonNull(parentContainerClass);
        Objects.requireNonNull(parentContainerId);
        ArrayList<ContainerDisplay<Object>> searchResults = new ArrayList<ContainerDisplay<Object>>();
        ArrayList<Object> allUserItems = new ArrayList<Object>();
        for (UADDisplay<?> uADDisplay : this._uadDisplays) {
            allUserItems.addAll(uADDisplay.search(userId, groupIds, keywords, orderByField, orderByType, -1, -1));
        }
        for (UADDisplay<?> uADDisplay : this._uadHierarchyDeclaration.getContainerUADDisplays()) {
            searchResults.addAll(this.getContainerDisplays(uADDisplay, parentContainerClass, parentContainerId, allUserItems));
        }
        for (UADDisplay<?> uADDisplay : this._uadHierarchyDeclaration.getNoncontainerUADDisplays()) {
            Class typeClass = uADDisplay.getTypeClass();
            for (Object e : allUserItems) {
                if (e == null || !typeClass.isAssignableFrom(e.getClass()) || !parentContainerId.equals(uADDisplay.getParentContainerId(e))) continue;
                searchResults.add((ContainerDisplay<Object>)e);
            }
        }
        return ListUtil.subList(searchResults, (int)start, (int)end);
    }

    public long searchCount(long userId, long[] groupIds, String keywords) {
        long count = 0L;
        for (UADDisplay<?> uadDisplay : this._uadDisplays) {
            count += uadDisplay.searchCount(userId, groupIds, keywords);
        }
        return count;
    }

    public <T> T unwrap(Object object) {
        if (object instanceof ContainerDisplay) {
            ContainerDisplay containerDisplay = (ContainerDisplay)object;
            return containerDisplay.getContainer();
        }
        return (T)object;
    }

    protected <T> Collection<ContainerDisplay<T>> getContainerDisplays(UADDisplay<T> containerUADDisplay, Class<?> parentContainerClass, Serializable parentContainerId, List<Object> allUserItems) {
        HashMap<Serializable, ContainerDisplay> topLevelCategories = new HashMap<Serializable, ContainerDisplay>();
        Class containerClass = containerUADDisplay.getTypeClass();
        for (Object userItem : allUserItems) {
            Object topLevelContainer;
            if (userItem == null || (topLevelContainer = containerUADDisplay.getTopLevelContainer(parentContainerClass, parentContainerId, userItem)) == null) continue;
            Serializable topLevelContainerId = containerUADDisplay.getPrimaryKey(topLevelContainer);
            if (containerClass.isAssignableFrom(userItem.getClass()) && Objects.equals(containerUADDisplay.getParentContainerId(userItem), parentContainerId)) {
                topLevelCategories.putIfAbsent(topLevelContainerId, new ContainerDisplay<Object>(topLevelContainer));
                continue;
            }
            topLevelCategories.compute(topLevelContainerId, (key, value) -> {
                if (value == null) {
                    value = new ContainerDisplay<Object>(topLevelContainer);
                }
                value.increment();
                return value;
            });
        }
        return topLevelCategories.values();
    }

    private void _addEntities(Map<Class<?>, List<Serializable>> entitiesMap, List<Serializable> entities, Class<?> typeClass) {
        if (!entitiesMap.containsKey(typeClass)) {
            entitiesMap.put(typeClass, new ArrayList());
        }
        List<Serializable> entitiesList = entitiesMap.get(typeClass);
        entitiesList.addAll(entities);
    }

    private <T> List<Serializable> _getContainerItemPKs(Class<?> parentContainerClass, Serializable parentContainerId, Class<?> typeClass, long userId) {
        ArrayList<Serializable> containerItemPKs = new ArrayList<Serializable>();
        UADDisplay<?> uadDisplay = this._getUADDisplayByTypeClass(typeClass);
        List searchItems = uadDisplay.search(userId, null, null, null, null, -1, -1);
        for (Object searchItem : searchItems) {
            if (parentContainerId.equals(uadDisplay.getParentContainerId(searchItem))) {
                containerItemPKs.add(uadDisplay.getPrimaryKey(searchItem));
                continue;
            }
            boolean containerItem = false;
            for (UADDisplay<?> containerUADDisplay : this._containerUADDisplays) {
                Object topLevelContainer = containerUADDisplay.getTopLevelContainer(parentContainerClass, parentContainerId, searchItem);
                if (topLevelContainer == null) continue;
                containerItem = true;
            }
            if (!containerItem) continue;
            containerItemPKs.add(uadDisplay.getPrimaryKey(searchItem));
        }
        return containerItemPKs;
    }

    private <T> UADDisplay<?> _getUADDisplayByObject(T object) {
        for (Class<?> typeClass : this._uadDisplayMap.keySet()) {
            if (!typeClass.isInstance(object)) continue;
            return this._uadDisplayMap.get(typeClass);
        }
        return null;
    }

    private <T> UADDisplay<?> _getUADDisplayByTypeClass(Class<?> typeClass) {
        if (!this._uadDisplayMap.containsKey(typeClass)) {
            return null;
        }
        return this._uadDisplayMap.get(typeClass);
    }

    private <T> UADDisplay<?> _getUADDisplayByTypeClassName(String typeClassName) {
        for (Class<?> typeClass : this._uadDisplayMap.keySet()) {
            if (!typeClassName.equals(typeClass.getName())) continue;
            return this._uadDisplayMap.get(typeClass);
        }
        return null;
    }
}

