/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.configuration;

import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListenerException;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.user.associated.data.web.internal.configuration.AnonymousUserConfiguration;
import com.liferay.user.associated.data.web.internal.configuration.AnonymousUserConfigurationRetriever;
import java.util.Dictionary;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import org.osgi.service.cm.Configuration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.user.associated.data.web.internal.configuration.AnonymousUserConfiguration"}, service={ConfigurationModelListener.class})
public class AnonymousUserConfigurationModelListener
implements ConfigurationModelListener {
    @Reference
    private AnonymousUserConfigurationRetriever _anonymousUserConfigurationRetriever;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void onBeforeSave(String pid, Dictionary<String, Object> properties) throws ConfigurationModelListenerException {
        try {
            long companyId = (Long)properties.get("companyId");
            this._companyLocalService.getCompanyById(companyId);
            this._userLocalService.getUserById(companyId, ((Long)properties.get("userId")).longValue());
            this._validateUniqueConfiguration(pid, companyId);
        }
        catch (Exception e) {
            throw new ConfigurationModelListenerException(e.getMessage(), AnonymousUserConfiguration.class, this.getClass(), properties);
        }
    }

    private void _validateUniqueConfiguration(String pid, long companyId) throws Exception {
        Optional<Configuration> configurationOptional = this._anonymousUserConfigurationRetriever.getOptional(companyId);
        if (!configurationOptional.isPresent()) {
            return;
        }
        Configuration configuration = configurationOptional.get();
        if (pid.equals(configuration.getPid())) {
            return;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)LocaleThreadLocal.getThemeDisplayLocale(), this.getClass());
        String message = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"an-anonymous-user-is-already-defined-for-the-company-x", (Object[])new Object[]{String.valueOf(companyId)});
        throw new Exception(message);
    }
}

