/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.util;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.user.associated.data.anonymizer.UADAnonymizer;
import com.liferay.user.associated.data.component.UADComponent;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.web.internal.display.UADApplicationSummaryDisplay;
import com.liferay.user.associated.data.web.internal.registry.UADRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UADApplicationSummaryHelper.class})
public class UADApplicationSummaryHelper {
    @Reference
    private Portal _portal;
    @Reference
    private UADRegistry _uadRegistry;

    public SearchContainer<UADApplicationSummaryDisplay> createSearchContainer(RenderRequest renderRequest, RenderResponse renderResponse, long userId) {
        PortletRequest portletRequest = (PortletRequest)renderRequest.getAttribute("javax.portlet.request");
        LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse((PortletResponse)renderRequest.getAttribute("javax.portlet.response"));
        PortletURL currentURL = PortletURLUtil.getCurrent((LiferayPortletRequest)this._portal.getLiferayPortletRequest(portletRequest), (LiferayPortletResponse)liferayPortletResponse);
        SearchContainer searchContainer = new SearchContainer(portletRequest, currentURL, null, null);
        searchContainer.setId("uadApplicationSummaryDisplays");
        searchContainer.setOrderByCol(this.getOrderByCol(renderRequest));
        searchContainer.setOrderByType(this.getOrderByType(renderRequest));
        Predicate<UADApplicationSummaryDisplay> predicate = this.getPredicate(this.getNavigation(renderRequest));
        List<UADApplicationSummaryDisplay> uadApplicationSummaryDisplays = this.getUADApplicationSummaryDisplays(portletRequest, userId);
        Supplier<Stream> streamSupplier = () -> {
            Stream stream = uadApplicationSummaryDisplays.stream();
            return stream.filter(predicate);
        };
        Stream summaryDisplayStream = streamSupplier.get();
        List results = summaryDisplayStream.sorted(this.getComparator(searchContainer.getOrderByCol(), searchContainer.getOrderByType())).skip(searchContainer.getStart()).limit(searchContainer.getDelta()).collect(Collectors.toList());
        searchContainer.setResults(results);
        summaryDisplayStream = streamSupplier.get();
        searchContainer.setTotal((int)summaryDisplayStream.count());
        return searchContainer;
    }

    public List<UADAnonymizer> getApplicationUADAnonymizers(String applicationKey) {
        Stream<UADDisplay> uadDisplayStream = this._uadRegistry.getApplicationUADDisplayStream(applicationKey);
        return uadDisplayStream.map(UADComponent::getTypeClass).map(Class::getName).map(key -> this._uadRegistry.getUADAnonymizer((String)key)).collect(Collectors.toList());
    }

    public Comparator<UADApplicationSummaryDisplay> getComparator(String orderByColumn, String orderByType) {
        Comparator<UADApplicationSummaryDisplay> comparator = Comparator.comparing(UADApplicationSummaryDisplay::getApplicationKey);
        if (orderByColumn.equals("items") || orderByColumn.equals("status")) {
            comparator = Comparator.comparingInt(UADApplicationSummaryDisplay::getCount);
        }
        if (orderByType.equals("desc")) {
            comparator = comparator.reversed();
        }
        return comparator;
    }

    public String getDefaultUADRegistryKey(String applicationKey) {
        List<UADDisplay> uadDisplays = this._uadRegistry.getApplicationUADDisplays(applicationKey);
        UADDisplay uadDisplay = uadDisplays.get(0);
        if (uadDisplay == null) {
            return null;
        }
        Class typeClass = uadDisplay.getTypeClass();
        return typeClass.getName();
    }

    public String getNavigation(RenderRequest renderRequest) {
        return ParamUtil.getString((PortletRequest)renderRequest, (String)"navigation", (String)"all");
    }

    public String getOrderByCol(RenderRequest renderRequest) {
        return ParamUtil.getString((PortletRequest)renderRequest, (String)"orderByCol", (String)"name");
    }

    public String getOrderByType(RenderRequest renderRequest) {
        return ParamUtil.getString((PortletRequest)renderRequest, (String)"orderByType", (String)"asc");
    }

    public Predicate<UADApplicationSummaryDisplay> getPredicate(String navigation) {
        if (navigation.equals("pending")) {
            return display -> display.getCount() > 0;
        }
        if (navigation.equals("done")) {
            return display -> display.getCount() <= 0;
        }
        return display -> true;
    }

    public int getReviewableUADEntitiesCount(Stream<UADDisplay> uadDisplayStream, long userId) {
        return uadDisplayStream.mapToInt(uadDisplay -> (int)uadDisplay.count(userId)).sum();
    }

    public int getTotalReviewableUADEntitiesCount(long userId) {
        return this.getReviewableUADEntitiesCount(this._uadRegistry.getUADDisplayStream(), userId);
    }

    public UADApplicationSummaryDisplay getUADApplicationSummaryDisplay(PortletRequest portletRequest, String applicationKey, long userId) {
        UADApplicationSummaryDisplay uadApplicationSummaryDisplay = new UADApplicationSummaryDisplay();
        List<UADDisplay> applicationUADDisplays = this._uadRegistry.getApplicationUADDisplays(applicationKey);
        int count = this.getReviewableUADEntitiesCount(applicationUADDisplays.stream(), userId);
        uadApplicationSummaryDisplay.setCount(count);
        uadApplicationSummaryDisplay.setApplicationKey(applicationKey);
        if (count > 0) {
            uadApplicationSummaryDisplay.setViewURL(this.getViewURL(portletRequest, applicationKey, userId));
        }
        return uadApplicationSummaryDisplay;
    }

    public List<UADApplicationSummaryDisplay> getUADApplicationSummaryDisplays(PortletRequest portletRequest, long userId) {
        ArrayList<UADApplicationSummaryDisplay> uadApplicationSummaryDisplays = new ArrayList<UADApplicationSummaryDisplay>();
        Set<String> applicationUADDisplayKeySet = this._uadRegistry.getApplicationUADDisplaysKeySet();
        for (String applicationKey : applicationUADDisplayKeySet) {
            uadApplicationSummaryDisplays.add(this.getUADApplicationSummaryDisplay(portletRequest, applicationKey, userId));
        }
        uadApplicationSummaryDisplays.sort((uadApplicationSummaryDisplay, uadApplicationSummaryDisplay2) -> {
            String applicationKey1 = uadApplicationSummaryDisplay.getApplicationKey();
            return applicationKey1.compareTo(uadApplicationSummaryDisplay2.getApplicationKey());
        });
        return uadApplicationSummaryDisplays;
    }

    public String getViewURL(PortletRequest portletRequest, String applicationKey, long userId) {
        LiferayPortletURL liferayPortletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)"com_liferay_user_associated_data_web_portlet_UserAssociatedData", (String)"RENDER_PHASE");
        liferayPortletURL.setParameter("mvcRenderCommandName", "/view_uad_entities");
        liferayPortletURL.setParameter("p_u_i_d", String.valueOf(userId));
        liferayPortletURL.setParameter("applicationKey", applicationKey);
        liferayPortletURL.setParameter("uadRegistryKey", this.getDefaultUADRegistryKey(applicationKey));
        return liferayPortletURL.toString();
    }
}

