/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.user.associated.data.web.internal.util.UADAnonymizerHelper;
import java.util.Objects;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SelectedUserHelper.class})
public class SelectedUserHelper {
    @Reference
    protected Portal portal;
    @Reference
    protected UADAnonymizerHelper uadAnonymizerHelper;

    public User getSelectedUser(PortletRequest portletRequest) throws PortalException {
        User selectedUser = this.portal.getSelectedUser(portletRequest);
        User user = this.portal.getUser(portletRequest);
        if (Objects.equals(user, selectedUser)) {
            throw new PortalException("The selected user cannot be the logged in user");
        }
        if (this.uadAnonymizerHelper.isAnonymousUser(selectedUser)) {
            throw new PortalException("The selected user cannot be the anonymous user");
        }
        return selectedUser;
    }

    public long getSelectedUserId(PortletRequest portletRequest) throws PortalException {
        User selectedUser = this.getSelectedUser(portletRequest);
        return selectedUser.getUserId();
    }
}

