/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.search;

import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.dao.search.ResultRow;
import com.liferay.portal.kernel.dao.search.ResultRowSplitter;
import com.liferay.portal.kernel.dao.search.ResultRowSplitterEntry;
import java.util.ArrayList;
import java.util.List;

public class UADExportProcessResultRowSplitter
implements ResultRowSplitter {
    public List<ResultRowSplitterEntry> split(List<ResultRow> resultRows) {
        ArrayList<ResultRowSplitterEntry> resultRowSplitterEntries = new ArrayList<ResultRowSplitterEntry>();
        ArrayList<ResultRow> failedProcesses = new ArrayList<ResultRow>();
        ArrayList<ResultRow> inProgressProcesses = new ArrayList<ResultRow>();
        ArrayList<ResultRow> successfulProcesses = new ArrayList<ResultRow>();
        for (ResultRow resultRow : resultRows) {
            BackgroundTask backgroundTask = (BackgroundTask)resultRow.getObject();
            if (backgroundTask.getStatus() == 2) {
                resultRow.setCssClass(resultRow.getCssClass() + "export-process-status-failed");
                failedProcesses.add(resultRow);
                continue;
            }
            if (backgroundTask.getStatus() == 3) {
                resultRow.setCssClass(resultRow.getCssClass() + "export-process-status-successful");
                successfulProcesses.add(resultRow);
                continue;
            }
            resultRow.setCssClass(resultRow.getCssClass() + "export-process-status-in-progress");
            inProgressProcesses.add(resultRow);
        }
        if (!inProgressProcesses.isEmpty()) {
            resultRowSplitterEntries.add(new ResultRowSplitterEntry("in-progress", inProgressProcesses));
        }
        if (!successfulProcesses.isEmpty()) {
            resultRowSplitterEntries.add(new ResultRowSplitterEntry("successful", successfulProcesses));
        }
        if (!failedProcesses.isEmpty()) {
            resultRowSplitterEntries.add(new ResultRowSplitterEntry("failed", failedProcesses));
        }
        return resultRowSplitterEntries;
    }
}

