/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.test.util;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.test.util.UserTestUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.test.util.WhenHasStatusByUserIdField;
import java.util.List;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseUADDisplayTestCase<T> {
    @DeleteAfterTestRun
    protected User user;
    private UADDisplay<T> _uadDisplay;

    @Before
    public void setUp() throws Exception {
        this.user = UserTestUtil.addUser();
        this._uadDisplay = this.getUADDisplay();
    }

    @Test
    public void testCount() throws Exception {
        this.addBaseModel(this.user.getUserId());
        Assert.assertEquals((long)1L, (long)this._uadDisplay.count(this.user.getUserId()));
    }

    @Test
    public void testGetAllByStatusByUserId() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasStatusByUserIdField));
        WhenHasStatusByUserIdField whenHasStatusByUserIdField = (WhenHasStatusByUserIdField)((Object)this);
        Object baseModel = whenHasStatusByUserIdField.addBaseModelWithStatusByUserId(TestPropsValues.getUserId(), this.user.getUserId());
        List baseModels = this._uadDisplay.getRange(this.user.getUserId(), -1, -1);
        Assert.assertEquals((String)baseModels.toString(), (long)1L, (long)baseModels.size());
        Assert.assertEquals(baseModel, baseModels.get(0));
    }

    @Test
    public void testGetAllWithNoBaseModel() throws Exception {
        Assert.assertEquals((long)0L, (long)this._uadDisplay.count(this.user.getUserId()));
    }

    @Test
    public void testGetTypeName() {
        Assert.assertTrue((String)"The type name should not be null", (boolean)Validator.isNotNull((String)this._uadDisplay.getTypeName(LocaleUtil.US)));
    }

    protected abstract BaseModel<?> addBaseModel(long var1) throws Exception;

    protected abstract UADDisplay<T> getUADDisplay();
}

