/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.exporter;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.user.associated.data.exporter.UADExporter;
import com.liferay.user.associated.data.util.UADDynamicQueryUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;

public abstract class DynamicQueryUADExporter<T extends BaseModel>
implements UADExporter<T> {
    @Override
    public long count(long userId) throws PortalException {
        return this.getActionableDynamicQuery(userId).performCount();
    }

    @Override
    public byte[] export(T baseModel) throws PortalException {
        String xml = this.toXmlString(baseModel);
        xml = this.formatXML(xml);
        try {
            return xml.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new PortalException((Throwable)uee);
        }
    }

    @Override
    public File exportAll(long userId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery(userId);
        Class clazz = this.getTypeClass();
        ZipWriter zipWriter = this.getZipWriter(userId, clazz.getName());
        actionableDynamicQuery.setPerformActionMethod(baseModel -> {
            try {
                this.writeToZip(baseModel, zipWriter);
            }
            catch (Exception e) {
                throw new PortalException((Throwable)e);
            }
        });
        actionableDynamicQuery.performActions();
        return zipWriter.getFile();
    }

    protected File createFolder(long userId) {
        StringBundler sb = new StringBundler(3);
        sb.append(SystemProperties.get((String)"java.io.tmpdir"));
        sb.append("/liferay/uad/");
        sb.append(userId);
        File file = new File(sb.toString());
        file.mkdirs();
        return file;
    }

    protected abstract ActionableDynamicQuery doGetActionableDynamicQuery();

    protected abstract String[] doGetUserIdFieldNames();

    protected String formatXML(String xml) {
        return XMLUtil.formatXML((String)xml);
    }

    protected ActionableDynamicQuery getActionableDynamicQuery(long userId) {
        return UADDynamicQueryUtil.addActionableDynamicQueryCriteria(this.doGetActionableDynamicQuery(), this.doGetUserIdFieldNames(), userId);
    }

    protected ZipWriter getZipWriter(long userId, String modelClassName) {
        File file = this.createFolder(userId);
        StringBundler sb = new StringBundler(6);
        sb.append(file.getAbsolutePath());
        sb.append("/");
        sb.append(modelClassName);
        sb.append("_");
        sb.append(Time.getShortTimestamp());
        sb.append(".zip");
        return ZipWriterFactoryUtil.getZipWriter((File)new File(sb.toString()));
    }

    protected String toXmlString(T baseModel) {
        return baseModel.toXmlString();
    }

    protected void writeToZip(T baseModel, ZipWriter zipWriter) throws Exception {
        byte[] data = this.export(baseModel);
        zipWriter.addEntry(baseModel.getPrimaryKeyObj() + ".xml", data);
    }
}

