/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.upload.web.internal;

import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.upload.AttachmentElementReplacer;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"format=html", "html.tag.name=img"}, service={AttachmentElementReplacer.class})
public class HTMLImageAttachmentElementReplacer
implements AttachmentElementReplacer {
    private PortletFileRepository _portletFileRepository;

    public String replace(String originalImgHtmlElement, FileEntry fileEntry) {
        Element element = this._toElement(originalImgHtmlElement);
        String fileEntryURL = this._portletFileRepository.getPortletFileEntryURL(null, fileEntry, "");
        element.attr("src", fileEntryURL);
        element.removeAttr("data-image-id");
        return element.toString();
    }

    @Reference(unbind="-")
    protected void setPortletFileRepository(PortletFileRepository portletFileRepository) {
        this._portletFileRepository = portletFileRepository;
    }

    private Element _toElement(String originalImgTag) {
        Document document = Jsoup.parseBodyFragment((String)originalImgTag);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        outputSettings.syntax(Document.OutputSettings.Syntax.xml);
        document.outputSettings(outputSettings);
        Element bodyElement = document.body();
        return bodyElement.child(0);
    }
}

