/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.upload.web.internal;

import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.document.library.kernel.antivirus.AntivirusScannerException;
import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.FileExtensionException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.document.library.kernel.util.DLValidator;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.upload.UploadResponseHandler;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.document.library.configuration.DLConfiguration"}, property={"upload.response.handler=multiple"})
public class MultipleUploadResponseHandler
implements UploadResponseHandler {
    private volatile DLConfiguration _dlConfiguration;
    @Reference
    private DLValidator _dlValidator;

    public JSONObject onFailure(PortletRequest portletRequest, PortalException pe) throws PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (pe instanceof AntivirusScannerException || pe instanceof DuplicateFileEntryException || pe instanceof FileExtensionException || pe instanceof FileNameException || pe instanceof FileSizeException || pe instanceof UploadRequestSizeException) {
            String errorMessage = "";
            int errorType = 0;
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (pe instanceof AntivirusScannerException) {
                AntivirusScannerException ase = (AntivirusScannerException)pe;
                errorMessage = themeDisplay.translate(ase.getMessageKey());
                errorType = 494;
            }
            if (pe instanceof DuplicateFileEntryException) {
                errorMessage = themeDisplay.translate("please-enter-a-unique-document-name");
                errorType = 490;
            } else if (pe instanceof FileExtensionException) {
                errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-extension-x", new Object[]{this._getAllowedFileExtensions()});
                errorType = 491;
            } else if (pe instanceof FileNameException) {
                errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-file-name");
            } else if (pe instanceof FileSizeException) {
                errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-file-size-no-larger-than-x", new Object[]{TextFormatter.formatStorageSize((double)this._dlValidator.getMaxAllowableSize(), (Locale)themeDisplay.getLocale())});
            } else if (pe instanceof UploadRequestSizeException) {
                errorType = 495;
            }
            jsonObject.put("message", errorMessage);
            jsonObject.put("status", errorType);
        }
        return jsonObject;
    }

    public JSONObject onSuccess(UploadPortletRequest uploadPortletRequest, FileEntry fileEntry) throws PortalException {
        String sourceFileName = uploadPortletRequest.getFileName("file");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("groupId", fileEntry.getGroupId());
        jsonObject.put("name", fileEntry.getTitle());
        jsonObject.put("title", sourceFileName);
        jsonObject.put("uuid", fileEntry.getUuid());
        return jsonObject;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._dlConfiguration = (DLConfiguration)ConfigurableUtil.createConfigurable(DLConfiguration.class, properties);
    }

    private String _getAllowedFileExtensions() {
        String allowedFileExtensionsString = "";
        Object[] allowedFileExtensions = this._dlConfiguration.fileExtensions();
        allowedFileExtensionsString = StringUtil.merge((Object[])allowedFileExtensions, (String)", ");
        return allowedFileExtensionsString;
    }
}

