/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.upload.web.internal;

import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.document.library.kernel.antivirus.AntivirusScannerException;
import com.liferay.document.library.kernel.exception.FileExtensionException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.upload.UploadResponseHandler;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.document.library.configuration.DLConfiguration"}, property={"upload.response.handler.system.default=true"})
public class DefaultUploadResponseHandler
implements UploadResponseHandler {
    private volatile DLConfiguration _dlConfiguration;

    public JSONObject onFailure(PortletRequest portletRequest, PortalException pe) throws PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("success", (Object)Boolean.FALSE);
        if (pe instanceof AntivirusScannerException || pe instanceof FileExtensionException || pe instanceof FileNameException || pe instanceof FileSizeException || pe instanceof UploadRequestSizeException) {
            String errorMessage = "";
            int errorType = 0;
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (pe instanceof AntivirusScannerException) {
                errorType = 494;
                AntivirusScannerException ase = (AntivirusScannerException)pe;
                errorMessage = themeDisplay.translate(ase.getMessageKey());
            } else if (pe instanceof FileExtensionException) {
                errorType = 491;
                errorMessage = this._getAllowedFileExtensions();
            } else if (pe instanceof FileNameException) {
                errorType = 492;
            } else if (pe instanceof FileSizeException) {
                errorType = 493;
            } else if (pe instanceof UploadRequestSizeException) {
                errorType = 495;
            }
            JSONObject errorJSONObject = JSONFactoryUtil.createJSONObject();
            errorJSONObject.put("errorType", errorType);
            errorJSONObject.put("message", errorMessage);
            jsonObject.put("error", errorJSONObject);
        }
        return jsonObject;
    }

    public JSONObject onSuccess(UploadPortletRequest uploadPortletRequest, FileEntry fileEntry) throws PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        JSONObject imageJSONObject = JSONFactoryUtil.createJSONObject();
        imageJSONObject.put("attributeDataImageId", "data-image-id");
        imageJSONObject.put("fileEntryId", fileEntry.getFileEntryId());
        imageJSONObject.put("groupId", fileEntry.getGroupId());
        imageJSONObject.put("mimeType", fileEntry.getMimeType());
        String randomId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"randomId");
        imageJSONObject.put("randomId", randomId);
        imageJSONObject.put("title", fileEntry.getTitle());
        imageJSONObject.put("type", "document");
        ThemeDisplay themeDisplay = (ThemeDisplay)uploadPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String url = PortletFileRepositoryUtil.getPortletFileEntryURL((ThemeDisplay)themeDisplay, (FileEntry)fileEntry, (String)"");
        imageJSONObject.put("url", url);
        imageJSONObject.put("uuid", fileEntry.getUuid());
        jsonObject.put("file", imageJSONObject);
        jsonObject.put("success", (Object)Boolean.TRUE);
        return jsonObject;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._dlConfiguration = (DLConfiguration)ConfigurableUtil.createConfigurable(DLConfiguration.class, properties);
    }

    private String _getAllowedFileExtensions() {
        String allowedFileExtensionsString = "";
        Object[] allowedFileExtensions = this._dlConfiguration.fileExtensions();
        allowedFileExtensionsString = StringUtil.merge((Object[])allowedFileExtensions, (String)", ");
        return allowedFileExtensionsString;
    }
}

