/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.upload;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.upload.UniqueFileNameProvider;
import com.liferay.upload.UploadFileEntryHandler;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseImageEditorUploadFileEntryHandler
implements UploadFileEntryHandler {
    private static final String _PARAMETER_NAME = "imageSelectorFileName";
    private static final Log _log = LogFactoryUtil.getLog(BaseImageEditorUploadFileEntryHandler.class);

    @Override
    public FileEntry upload(UploadPortletRequest uploadPortletRequest) throws IOException, PortalException {
        this.checkPermissions(uploadPortletRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)uploadPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String fileName = uploadPortletRequest.getFileName(_PARAMETER_NAME);
        if (Validator.isNotNull((String)fileName)) {
            try (InputStream inputStream = uploadPortletRequest.getFileAsStream(_PARAMETER_NAME);){
                FileEntry fileEntry = this._addTempFileEntry(fileName, inputStream, _PARAMETER_NAME, uploadPortletRequest, themeDisplay);
                return fileEntry;
            }
        }
        return this._editImageFileEntry(uploadPortletRequest, themeDisplay);
    }

    protected abstract void checkPermissions(UploadPortletRequest var1) throws PortalException;

    protected abstract DLAppService getDLAppService();

    protected abstract String getFolderName();

    protected abstract UniqueFileNameProvider getUniqueFileNameProvider();

    private FileEntry _addTempFileEntry(String fileName, InputStream inputStream, String parameterName, UploadPortletRequest uploadPortletRequest, ThemeDisplay themeDisplay) throws PortalException {
        UniqueFileNameProvider uniqueFileNameProvider = this.getUniqueFileNameProvider();
        String uniqueFileName = uniqueFileNameProvider.provide(fileName, curFileName -> this._exists(themeDisplay, (String)curFileName));
        return TempFileEntryUtil.addTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)this.getFolderName(), (String)uniqueFileName, (InputStream)inputStream, (String)uploadPortletRequest.getContentType(parameterName));
    }

    private FileEntry _editImageFileEntry(UploadPortletRequest uploadPortletRequest, ThemeDisplay themeDisplay) throws IOException, PortalException {
        long fileEntryId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"fileEntryId");
        DLAppService dlAppService = this.getDLAppService();
        FileEntry fileEntry = dlAppService.getFileEntry(fileEntryId);
        try (InputStream inputStream = uploadPortletRequest.getFileAsStream("imageBlob");){
            FileEntry fileEntry2 = this._addTempFileEntry(fileEntry.getFileName(), inputStream, "imageBlob", uploadPortletRequest, themeDisplay);
            return fileEntry2;
        }
    }

    private boolean _exists(ThemeDisplay themeDisplay, String curFileName) {
        try {
            FileEntry tempFileEntry = TempFileEntryUtil.getTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)this.getFolderName(), (String)curFileName);
            return tempFileEntry != null;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return false;
        }
    }
}

