/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.SystemEvent;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.SystemEventLocalServiceUtil;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.trash.kernel.model.TrashEntry;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletRequest;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class BaseTrashHandler
implements TrashHandler {
    private static final Log _log = LogFactoryUtil.getLog(BaseTrashHandler.class);

    public SystemEvent addDeletionSystemEvent(long userId, long groupId, long classPK, String classUuid, String referrerClassName) throws PortalException {
        JSONObject extraDataJSONObject = JSONUtil.put((String)"inTrash", (Object)true);
        return SystemEventLocalServiceUtil.addSystemEvent((long)userId, (long)groupId, (String)this.getSystemEventClassName(), (long)classPK, (String)classUuid, (String)referrerClassName, (int)1, (String)extraDataJSONObject.toString());
    }

    public void checkRestorableEntry(long classPK, long containerModelId, String newName) throws PortalException {
    }

    public void checkRestorableEntry(TrashEntry trashEntry, long containerModelId, String newName) throws PortalException {
    }

    public ContainerModel getContainerModel(long containerModelId) throws PortalException {
        return null;
    }

    public String getContainerModelClassName(long classPK) {
        return "";
    }

    public String getContainerModelName() {
        return "";
    }

    public List<ContainerModel> getContainerModels(long classPK, long containerModelId, int start, int end) throws PortalException {
        return Collections.emptyList();
    }

    public int getContainerModelsCount(long classPK, long containerModelId) throws PortalException {
        return 0;
    }

    public String getDeleteMessage() {
        return "deleted-in-x";
    }

    public long getDestinationContainerModelId(long classPK, long destinationContainerModelId) {
        return destinationContainerModelId;
    }

    public Filter getExcludeFilter(SearchContext searchContext) {
        return null;
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException {
        return null;
    }

    public ContainerModel getParentContainerModel(TrashedModel trashedModel) throws PortalException {
        if (trashedModel == null || !(trashedModel instanceof ContainerModel)) {
            return null;
        }
        ContainerModel containerModel = (ContainerModel)trashedModel;
        return this.getContainerModel(containerModel.getParentContainerModelId());
    }

    public List<ContainerModel> getParentContainerModels(long classPK) throws PortalException {
        return Collections.emptyList();
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        return "";
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        return "";
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException {
        return "";
    }

    public String getRootContainerModelName() {
        return "";
    }

    public String getSubcontainerModelName() {
        return "";
    }

    public String getSystemEventClassName() {
        return this.getClassName();
    }

    public String getTrashContainedModelName() {
        return "";
    }

    public int getTrashContainedModelsCount(long classPK) throws PortalException {
        return 0;
    }

    public String getTrashContainerModelName() {
        return "";
    }

    public int getTrashContainerModelsCount(long classPK) throws PortalException {
        return 0;
    }

    public TrashedModel getTrashedModel(long classPK) {
        return null;
    }

    public int getTrashModelsCount(long classPK) throws PortalException {
        return 0;
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException {
        AssetRenderer assetRenderer;
        AssetRendererFactory<?> assetRendererFactory = this.getAssetRendererFactory();
        if (assetRendererFactory != null && (assetRenderer = assetRendererFactory.getAssetRenderer(classPK)) instanceof TrashRenderer) {
            return (TrashRenderer)assetRenderer;
        }
        return null;
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException {
        if (trashActionId.equals("MOVE")) {
            return false;
        }
        String actionId = trashActionId;
        if (trashActionId.equals("OVERWRITE") || trashActionId.equals("RESTORE")) {
            actionId = "DELETE";
        } else if (trashActionId.equals("RENAME")) {
            actionId = "UPDATE";
        }
        return this.hasPermission(permissionChecker, classPK, actionId);
    }

    public boolean isContainerModel() {
        return false;
    }

    public boolean isDeletable(long classPK) throws PortalException {
        return this.hasTrashPermission(PermissionThreadLocal.getPermissionChecker(), 0L, classPK, "DELETE");
    }

    public boolean isMovable(long classPK) throws PortalException {
        return false;
    }

    public boolean isRestorable(long classPK) throws PortalException {
        return true;
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
    }

    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        if (this.isRestorable(classPK)) {
            this.restoreTrashEntry(userId, classPK);
        }
        Class<?> clazz = this.getClass();
        _log.error((Object)("moveTrashEntry() is not implemented in " + clazz.getName()));
        throw new SystemException();
    }

    public void restoreRelatedTrashEntry(String className, long classPK) throws PortalException {
    }

    public void updateTitle(long classPK, String title) throws PortalException {
    }

    protected AssetRendererFactory<?> getAssetRendererFactory() {
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)this.getClassName());
    }

    protected abstract boolean hasPermission(PermissionChecker var1, long var2, String var4) throws PortalException;
}

