/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.BaseTrashRenderer;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseJSPTrashRenderer
extends BaseTrashRenderer {
    private static final Log _log = LogFactoryUtil.getLog(BaseJSPTrashRenderer.class);
    private ServletContext _servletContext;

    public abstract String getJspPath(HttpServletRequest var1, String var2);

    public boolean include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String template) throws Exception {
        String jspPath = this.getJspPath(httpServletRequest, template);
        if (Validator.isNull((String)jspPath)) {
            return false;
        }
        ServletContext servletContext = this.getServletContext(httpServletRequest);
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(jspPath);
        try {
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return true;
        }
        catch (ServletException servletException) {
            _log.error((Object)("Unable to include JSP " + jspPath), (Throwable)servletException);
            throw new IOException("Unable to include " + jspPath, servletException);
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    protected ServletContext getServletContext(HttpServletRequest httpServletRequest) {
        if (this._servletContext != null) {
            return this._servletContext;
        }
        return (ServletContext)httpServletRequest.getAttribute("CTX");
    }
}

